/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.table;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.connector.jdbc.core.table.FilterHandlingPolicy;
import org.apache.flink.table.factories.FactoryUtil;

@PublicEvolving
public class JdbcConnectorOptions {
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The JDBC database URL.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("The JDBC table name.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("The JDBC user name.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("The JDBC password.");
    public static final ConfigOption<String> DRIVER = ConfigOptions.key((String)"driver").stringType().noDefaultValue().withDescription("The class name of the JDBC driver to use to connect to this URL. If not set, it will automatically be derived from the URL.");
    public static final ConfigOption<String> COMPATIBLE_MODE = ConfigOptions.key((String)"compatible-mode").stringType().noDefaultValue().withDescription("The compatible mode of database.");
    public static final ConfigOption<Duration> MAX_RETRY_TIMEOUT = ConfigOptions.key((String)"connection.max-retry-timeout").durationType().defaultValue((Object)Duration.ofSeconds(60L)).withDescription("Maximum timeout between retries.");
    public static final ConfigOption<Integer> SINK_PARALLELISM = FactoryUtil.SINK_PARALLELISM;
    public static final ConfigOption<String> SCAN_PARTITION_COLUMN = ConfigOptions.key((String)"scan.partition.column").stringType().noDefaultValue().withDescription("The column name used for partitioning the input.");
    public static final ConfigOption<Integer> SCAN_PARTITION_NUM = ConfigOptions.key((String)"scan.partition.num").intType().noDefaultValue().withDescription("The number of partitions.");
    public static final ConfigOption<Long> SCAN_PARTITION_LOWER_BOUND = ConfigOptions.key((String)"scan.partition.lower-bound").longType().noDefaultValue().withDescription("The smallest value of the first partition.");
    public static final ConfigOption<Long> SCAN_PARTITION_UPPER_BOUND = ConfigOptions.key((String)"scan.partition.upper-bound").longType().noDefaultValue().withDescription("The largest value of the last partition.");
    public static final ConfigOption<Integer> SCAN_FETCH_SIZE = ConfigOptions.key((String)"scan.fetch-size").intType().defaultValue((Object)0).withDescription("Gives the reader a hint as to the number of rows that should be fetched from the database per round-trip when reading. If the value is zero, this hint is ignored.");
    public static final ConfigOption<Boolean> SCAN_AUTO_COMMIT = ConfigOptions.key((String)"scan.auto-commit").booleanType().defaultValue((Object)true).withDescription("Sets whether the driver is in auto-commit mode.");
    @Deprecated
    public static final ConfigOption<Long> LOOKUP_CACHE_MAX_ROWS = ConfigOptions.key((String)"lookup.cache.max-rows").longType().defaultValue((Object)-1L).withDescription("The max number of rows of lookup cache, over this value, the oldest rows will be eliminated. \"cache.max-rows\" and \"cache.ttl\" options must all be specified if any of them is specified.");
    @Deprecated
    public static final ConfigOption<Duration> LOOKUP_CACHE_TTL = ConfigOptions.key((String)"lookup.cache.ttl").durationType().defaultValue((Object)Duration.ofSeconds(10L)).withDescription("The cache time to live.");
    @Deprecated
    public static final ConfigOption<Integer> LOOKUP_MAX_RETRIES = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times if lookup database failed.");
    @Deprecated
    public static final ConfigOption<Boolean> LOOKUP_CACHE_MISSING_KEY = ConfigOptions.key((String)"lookup.cache.caching-missing-key").booleanType().defaultValue((Object)true).withDescription("Flag to cache missing key. true by default");
    public static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").intType().defaultValue((Object)100).withDescription("The flush max size (includes all append, upsert and delete records), over this number of records, will flush data.");
    public static final ConfigOption<Duration> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("The flush interval mills, over this time, asynchronous threads will flush data.");
    public static final ConfigOption<Integer> SINK_MAX_RETRIES = ConfigOptions.key((String)"sink.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times if writing records to database failed.");
    public static final ConfigOption<FilterHandlingPolicy> FILTER_HANDLING_POLICY = ConfigOptions.key((String)"filter.handling.policy").enumType(FilterHandlingPolicy.class).defaultValue((Object)FilterHandlingPolicy.ALWAYS).withDescription("Fine-grained configuration to control filter push down for jdbc Table/SQL source.");

    protected JdbcConnectorOptions() {
    }
}

