/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.mysql.database.catalog;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.catalog.JdbcCatalogTypeMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MySqlTypeMapper
implements JdbcCatalogTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlTypeMapper.class);
    private static final String MYSQL_UNKNOWN = "UNKNOWN";
    private static final String MYSQL_BIT = "BIT";
    private static final String MYSQL_TINYINT = "TINYINT";
    private static final String MYSQL_TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String MYSQL_SMALLINT = "SMALLINT";
    private static final String MYSQL_SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String MYSQL_MEDIUMINT = "MEDIUMINT";
    private static final String MYSQL_MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String MYSQL_INT = "INT";
    private static final String MYSQL_INT_UNSIGNED = "INT UNSIGNED";
    private static final String MYSQL_INTEGER = "INTEGER";
    private static final String MYSQL_INTEGER_UNSIGNED = "INTEGER UNSIGNED";
    private static final String MYSQL_BIGINT = "BIGINT";
    private static final String MYSQL_BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String MYSQL_DECIMAL = "DECIMAL";
    private static final String MYSQL_DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String MYSQL_FLOAT = "FLOAT";
    private static final String MYSQL_FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String MYSQL_DOUBLE = "DOUBLE";
    private static final String MYSQL_DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String MYSQL_CHAR = "CHAR";
    private static final String MYSQL_VARCHAR = "VARCHAR";
    private static final String MYSQL_TINYTEXT = "TINYTEXT";
    private static final String MYSQL_MEDIUMTEXT = "MEDIUMTEXT";
    private static final String MYSQL_TEXT = "TEXT";
    private static final String MYSQL_LONGTEXT = "LONGTEXT";
    private static final String MYSQL_JSON = "JSON";
    private static final String MYSQL_DATE = "DATE";
    private static final String MYSQL_DATETIME = "DATETIME";
    private static final String MYSQL_TIME = "TIME";
    private static final String MYSQL_TIMESTAMP = "TIMESTAMP";
    private static final String MYSQL_YEAR = "YEAR";
    private static final String MYSQL_TINYBLOB = "TINYBLOB";
    private static final String MYSQL_MEDIUMBLOB = "MEDIUMBLOB";
    private static final String MYSQL_BLOB = "BLOB";
    private static final String MYSQL_LONGBLOB = "LONGBLOB";
    private static final String MYSQL_BINARY = "BINARY";
    private static final String MYSQL_VARBINARY = "VARBINARY";
    private static final String MYSQL_GEOMETRY = "GEOMETRY";
    private static final int RAW_TIME_LENGTH = 10;
    private static final int RAW_TIMESTAMP_LENGTH = 19;
    private final String databaseVersion;
    private final String driverVersion;

    public MySqlTypeMapper(String databaseVersion, String driverVersion) {
        this.databaseVersion = databaseVersion;
        this.driverVersion = driverVersion;
    }

    @Override
    public DataType mapping(ObjectPath tablePath, ResultSetMetaData metadata, int colIndex) throws SQLException {
        String mysqlType = metadata.getColumnTypeName(colIndex).toUpperCase();
        String columnName = metadata.getColumnName(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (mysqlType) {
            case "BIT": {
                return DataTypes.BOOLEAN();
            }
            case "TINYBLOB": 
            case "MEDIUMBLOB": 
            case "BLOB": 
            case "LONGBLOB": 
            case "VARBINARY": 
            case "BINARY": {
                return DataTypes.BYTES();
            }
            case "TINYINT": {
                return DataTypes.TINYINT();
            }
            case "TINYINT UNSIGNED": 
            case "SMALLINT": {
                return DataTypes.SMALLINT();
            }
            case "SMALLINT UNSIGNED": 
            case "MEDIUMINT": 
            case "MEDIUMINT UNSIGNED": 
            case "INT": 
            case "INTEGER": {
                return DataTypes.INT();
            }
            case "INT UNSIGNED": 
            case "INTEGER UNSIGNED": 
            case "BIGINT": {
                return DataTypes.BIGINT();
            }
            case "BIGINT UNSIGNED": {
                return DataTypes.DECIMAL((int)20, (int)0);
            }
            case "DECIMAL": {
                return DataTypes.DECIMAL((int)precision, (int)scale);
            }
            case "DECIMAL UNSIGNED": {
                this.checkMaxPrecision(tablePath, columnName, precision);
                return DataTypes.DECIMAL((int)(precision + 1), (int)scale);
            }
            case "FLOAT": {
                return DataTypes.FLOAT();
            }
            case "FLOAT UNSIGNED": {
                LOG.warn("{} will probably cause value overflow.", (Object)MYSQL_FLOAT_UNSIGNED);
                return DataTypes.FLOAT();
            }
            case "DOUBLE": {
                return DataTypes.DOUBLE();
            }
            case "DOUBLE UNSIGNED": {
                LOG.warn("{} will probably cause value overflow.", (Object)MYSQL_DOUBLE_UNSIGNED);
                return DataTypes.DOUBLE();
            }
            case "CHAR": {
                return DataTypes.CHAR((int)precision);
            }
            case "VARCHAR": 
            case "TINYTEXT": 
            case "MEDIUMTEXT": 
            case "TEXT": {
                return DataTypes.VARCHAR((int)precision);
            }
            case "JSON": {
                return DataTypes.STRING();
            }
            case "LONGTEXT": {
                LOG.warn("Type '{}' has a maximum precision of 536870911 in MySQL. Due to limitations in the Flink type system, the precision will be set to 2147483647.", (Object)MYSQL_LONGTEXT);
                return DataTypes.STRING();
            }
            case "DATE": {
                return DataTypes.DATE();
            }
            case "TIME": {
                return this.isExplicitPrecision(precision, 10) ? DataTypes.TIME((int)(precision - 10 - 1)) : DataTypes.TIME((int)0);
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                boolean explicitPrecision = this.isExplicitPrecision(precision, 19);
                if (explicitPrecision) {
                    int p = precision - 19 - 1;
                    if (p <= 6 && p >= 0) {
                        return DataTypes.TIMESTAMP((int)p);
                    }
                    return p > 6 ? DataTypes.TIMESTAMP((int)6) : DataTypes.TIMESTAMP((int)0);
                }
                return DataTypes.TIMESTAMP((int)0);
            }
        }
        String jdbcColumnName = metadata.getColumnName(colIndex);
        throw new UnsupportedOperationException(String.format("Doesn't support MySQL type '%s' on column '%s' in MySQL version %s, driver version %s yet.", mysqlType, jdbcColumnName, this.databaseVersion, this.driverVersion));
    }

    private boolean isExplicitPrecision(int precision, int defaultPrecision) {
        return precision > defaultPrecision && precision - defaultPrecision - 1 <= 9;
    }

    private void checkMaxPrecision(ObjectPath tablePath, String columnName, int precision) {
        if (precision >= 38) {
            throw new CatalogException(String.format("Precision %s of table %s column name %s in type %s exceeds DecimalType.MAX_PRECISION %s.", precision, tablePath.getFullName(), columnName, MYSQL_DECIMAL_UNSIGNED, 38));
        }
    }
}

