/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.oceanbase.database.catalog;

import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.core.database.catalog.AbstractJdbcCatalog;
import org.apache.flink.connector.jdbc.core.database.catalog.JdbcCatalogTypeMapper;
import org.apache.flink.connector.jdbc.core.table.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.oceanbase.database.catalog.OceanBaseTypeMapper;
import org.apache.flink.connector.jdbc.oceanbase.database.dialect.OceanBaseCompatibleMode;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public class OceanBaseCatalog
extends AbstractJdbcCatalog {
    private static final Set<String> builtinDatabases = new HashSet<String>(){
        {
            this.add("__public");
            this.add("information_schema");
            this.add("mysql");
            this.add("oceanbase");
            this.add("LBACSYS");
            this.add("ORAAUDITOR");
        }
    };
    private final OceanBaseCompatibleMode compatibleMode;
    private final JdbcCatalogTypeMapper dialectTypeMapper;

    public OceanBaseCatalog(ClassLoader userClassLoader, String catalogName, OceanBaseCompatibleMode compatibleMode, String defaultDatabase, String username, String pwd, String baseUrl) {
        this(userClassLoader, catalogName, compatibleMode, defaultDatabase, baseUrl, JdbcConnectionOptions.getBriefAuthProperties(username, pwd));
    }

    public OceanBaseCatalog(ClassLoader userClassLoader, String catalogName, OceanBaseCompatibleMode compatibleMode, String defaultDatabase, String baseUrl, Properties connectionProperties) {
        super(userClassLoader, catalogName, defaultDatabase, baseUrl, connectionProperties);
        this.compatibleMode = compatibleMode;
        this.dialectTypeMapper = new OceanBaseTypeMapper(compatibleMode);
    }

    public List<String> listDatabases() throws CatalogException {
        String query = this.compatibleMode.isMySQLMode() ? "SELECT `SCHEMA_NAME` FROM `INFORMATION_SCHEMA`.`SCHEMATA`" : "SELECT USERNAME FROM ALL_USERS";
        return this.extractColumnValuesBySQL(this.defaultUrl, query, 1, dbName -> !builtinDatabases.contains(dbName), new Object[0]);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)databaseName), (Object)"Database name must not be blank.");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        String sql = this.compatibleMode.isMySQLMode() ? "SELECT TABLE_NAME FROM information_schema.`TABLES` WHERE TABLE_SCHEMA = ?" : "SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER = ?";
        return this.extractColumnValuesBySQL(this.defaultUrl, sql, 1, null, databaseName);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        String query = this.compatibleMode.isMySQLMode() ? "SELECT TABLE_NAME FROM information_schema.`TABLES` WHERE TABLE_SCHEMA = ? and TABLE_NAME = ?" : "SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER = ? and TABLE_NAME = ?";
        return !this.extractColumnValuesBySQL(this.defaultUrl, query, 1, null, tablePath.getDatabaseName(), tablePath.getObjectName()).isEmpty();
    }

    @Override
    protected Optional<UniqueConstraint> getPrimaryKey(DatabaseMetaData metaData, String database, String schema, String table) throws SQLException {
        if (this.compatibleMode.isMySQLMode()) {
            return super.getPrimaryKey(metaData, database, null, table);
        }
        return super.getPrimaryKey(metaData, null, database, table);
    }

    @Override
    protected Map<String, String> getOptions(ObjectPath tablePath) {
        Map<String, String> options = super.getOptions(tablePath);
        options.put(JdbcConnectorOptions.COMPATIBLE_MODE.key(), this.compatibleMode.toString());
        return options;
    }

    @Override
    protected DataType fromJDBCType(ObjectPath tablePath, ResultSetMetaData metadata, int colIndex) throws SQLException {
        return this.dialectTypeMapper.mapping(tablePath, metadata, colIndex);
    }

    @Override
    protected String getTableName(ObjectPath tablePath) {
        return tablePath.getObjectName();
    }

    @Override
    protected String getSchemaName(ObjectPath tablePath) {
        return null;
    }

    @Override
    protected String getSchemaTableName(ObjectPath tablePath) {
        return tablePath.getObjectName();
    }
}

