/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.oceanbase.database.catalog;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.catalog.JdbcCatalogTypeMapper;
import org.apache.flink.connector.jdbc.oceanbase.database.dialect.OceanBaseCompatibleMode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.types.DataType;

@Internal
public class OceanBaseTypeMapper
implements JdbcCatalogTypeMapper {
    private static final int RAW_TIME_LENGTH = 10;
    private static final int RAW_TIMESTAMP_LENGTH = 19;
    private static final int TYPE_BINARY_FLOAT = 100;
    private static final int TYPE_BINARY_DOUBLE = 101;
    private final OceanBaseCompatibleMode compatibleMode;

    public OceanBaseTypeMapper(OceanBaseCompatibleMode compatibleMode) {
        this.compatibleMode = compatibleMode;
    }

    @Override
    public DataType mapping(ObjectPath tablePath, ResultSetMetaData metadata, int colIndex) throws SQLException {
        String typeName = metadata.getColumnTypeName(colIndex).toUpperCase();
        int jdbcType = metadata.getColumnType(colIndex);
        String columnName = metadata.getColumnName(colIndex);
        int precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        switch (jdbcType) {
            case -7: {
                return DataTypes.BOOLEAN();
            }
            case -6: {
                return this.isUnsignedType(typeName) || precision > 4 ? DataTypes.SMALLINT() : DataTypes.TINYINT();
            }
            case 5: {
                return this.isUnsignedType(typeName) ? DataTypes.INT() : DataTypes.SMALLINT();
            }
            case 4: {
                return !typeName.toUpperCase().startsWith("MEDIUMINT") && this.isUnsignedType(typeName) ? DataTypes.BIGINT() : DataTypes.INT();
            }
            case -5: {
                return this.isUnsignedType(typeName) ? DataTypes.DECIMAL((int)20, (int)0) : DataTypes.BIGINT();
            }
            case 2: 
            case 3: 
            case 6: {
                if (this.compatibleMode.isMySQLMode()) {
                    return this.isUnsignedType(typeName) ? this.getDecimalType(precision + 1, scale) : this.getDecimalType(precision, scale);
                }
                return this.getNumericType(precision, scale);
            }
            case 7: 
            case 100: {
                return DataTypes.FLOAT();
            }
            case 8: 
            case 101: {
                return DataTypes.DOUBLE();
            }
            case 91: {
                return "YEAR".equals(typeName) ? DataTypes.INT() : DataTypes.DATE();
            }
            case 92: {
                return this.isExplicitPrecision(precision, 10) ? DataTypes.TIME((int)(precision - 10 - 1)) : DataTypes.TIME((int)0);
            }
            case 93: {
                return typeName.equalsIgnoreCase("DATE") ? DataTypes.DATE() : (this.isExplicitPrecision(precision, 19) ? DataTypes.TIMESTAMP((int)(precision - 19 - 1)) : DataTypes.TIMESTAMP((int)0));
            }
            case -15: 
            case 1: {
                return DataTypes.CHAR((int)precision);
            }
            case -9: 
            case -1: 
            case 12: {
                return precision > 0 ? DataTypes.VARCHAR((int)precision) : DataTypes.STRING();
            }
            case 2005: {
                return DataTypes.STRING();
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return DataTypes.BYTES();
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support type '%s' on column '%s'.", typeName, columnName));
    }

    private DataType getNumericType(int precision, int scale) {
        if (precision == 0) {
            return DataTypes.STRING();
        }
        if (scale <= 0) {
            int width = precision - scale;
            if (width < 3) {
                return DataTypes.TINYINT();
            }
            if (width < 5) {
                return DataTypes.SMALLINT();
            }
            if (width < 10) {
                return DataTypes.INT();
            }
            if (width < 19) {
                return DataTypes.BIGINT();
            }
        }
        return this.getDecimalType(precision, scale);
    }

    private DataType getDecimalType(int precision, int scale) {
        if (precision >= 38 || precision == 0) {
            return DataTypes.STRING();
        }
        return DataTypes.DECIMAL((int)precision, (int)scale);
    }

    private boolean isUnsignedType(String typeName) {
        return typeName.toUpperCase().contains("UNSIGNED");
    }

    private boolean isExplicitPrecision(int precision, int defaultPrecision) {
        return precision > defaultPrecision && precision - defaultPrecision - 1 <= (this.compatibleMode.isMySQLMode() ? 6 : 9);
    }
}

