/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.split;

import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcSlideTimingParameterProvider
implements JdbcParameterValuesProvider {
    private final long slideStepMills;
    private final long slideSpanMills;
    private final long splitGenerateDelayMillis;
    @Nonnull
    private Long startMills;

    public JdbcSlideTimingParameterProvider(Long startMills, long slideSpanMills, long slideStepMills, long splitGenerateDelayMillis) {
        this.startMills = (Long)Preconditions.checkNotNull((Object)startMills);
        Preconditions.checkArgument((startMills > 0L ? 1 : 0) != 0, (Object)"'startMillis' of JdbcSlideTimingParameterProvider must be greater than 0. ");
        Preconditions.checkArgument((slideSpanMills > 0L || slideStepMills > 0L ? 1 : 0) != 0, (Object)"JdbcSlideTimingParameterProvider parameters must satisfy slideSpanMills > 0 and slideStepMills > 0");
        Preconditions.checkArgument((splitGenerateDelayMillis >= 0L ? 1 : 0) != 0, (Object)"JdbcSlideTimingParameterProvider parameters must satisfy splitGenerateDelayMillis >= 0");
        this.slideStepMills = slideStepMills;
        this.slideSpanMills = slideSpanMills;
        this.splitGenerateDelayMillis = splitGenerateDelayMillis;
    }

    private boolean nextSplitAvailable(Long nextSpanStartMillis) {
        long delayedNextSpanStartMillis = nextSpanStartMillis + this.splitGenerateDelayMillis;
        long currentAvailableMillis = this.currentAvailableMillis();
        return currentAvailableMillis >= delayedNextSpanStartMillis && currentAvailableMillis - delayedNextSpanStartMillis >= this.slideSpanMills;
    }

    @Override
    public Long getLatestOptionalState() {
        return this.startMills;
    }

    @Override
    public void setOptionalState(Serializable optionalState) {
        Preconditions.checkArgument(((Long)optionalState > 0L ? 1 : 0) != 0);
        this.startMills = (Long)optionalState;
    }

    public Long currentAvailableMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public Serializable[][] getParameterValues() {
        ArrayList<Serializable[]> tmpList = new ArrayList<Serializable[]>();
        while (this.nextSplitAvailable(this.startMills)) {
            Serializable[] params = new Serializable[]{this.startMills, Long.valueOf(this.startMills + this.slideSpanMills)};
            tmpList.add(params);
            this.startMills = this.startMills + this.slideStepMills;
        }
        return (Serializable[][])tmpList.toArray((T[])new Serializable[0][]);
    }
}

