/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.utils;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.core.database.catalog.factory.JdbcCatalogFactoryOptions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcUtils.class);
    public static final String PROPERTIES_PREFIX = "connection-properties.";

    public static Properties getConnectionProperties(ReadableConfig config) {
        Properties result = JdbcConnectionOptions.getBriefAuthProperties((String)config.get(JdbcCatalogFactoryOptions.USERNAME), (String)config.get(JdbcCatalogFactoryOptions.PASSWORD));
        Preconditions.checkArgument((boolean)(config instanceof Configuration));
        Map configMap = ((Configuration)config).toMap();
        configMap.forEach((k, v) -> {
            if (Objects.nonNull(k) && Objects.nonNull(v) && k.startsWith(PROPERTIES_PREFIX)) {
                result.setProperty(k.substring(PROPERTIES_PREFIX.length()), (String)v);
            }
        });
        return result;
    }

    public static void setRecordToStatement(PreparedStatement upload, int[] typesArray, Row row) throws SQLException {
        if (typesArray != null && typesArray.length > 0 && typesArray.length != row.getArity()) {
            LOG.warn("Column SQL types array doesn't match arity of passed Row! Check the passed array...");
        }
        if (typesArray == null) {
            for (int index = 0; index < row.getArity(); ++index) {
                LOG.warn("Unknown column type for column {}. Best effort approach to set its value: {}.", (Object)(index + 1), row.getField(index));
                upload.setObject(index + 1, row.getField(index));
            }
        } else {
            for (int i = 0; i < row.getArity(); ++i) {
                JdbcUtils.setField(upload, typesArray[i], row.getField(i), i);
            }
        }
    }

    public static void setField(PreparedStatement upload, int type, Object field, int index) throws SQLException {
        if (field == null) {
            upload.setNull(index + 1, type);
        } else {
            try {
                switch (type) {
                    case 0: {
                        upload.setNull(index + 1, type);
                        break;
                    }
                    case -7: 
                    case 16: {
                        upload.setBoolean(index + 1, (Boolean)field);
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -1: 
                    case 1: 
                    case 12: {
                        upload.setString(index + 1, (String)field);
                        break;
                    }
                    case -6: {
                        upload.setByte(index + 1, (Byte)field);
                        break;
                    }
                    case 5: {
                        upload.setShort(index + 1, (Short)field);
                        break;
                    }
                    case 4: {
                        upload.setInt(index + 1, (Integer)field);
                        break;
                    }
                    case -5: {
                        upload.setLong(index + 1, (Long)field);
                        break;
                    }
                    case 7: {
                        upload.setFloat(index + 1, ((Float)field).floatValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        upload.setDouble(index + 1, (Double)field);
                        break;
                    }
                    case 2: 
                    case 3: {
                        upload.setBigDecimal(index + 1, (BigDecimal)field);
                        break;
                    }
                    case 91: {
                        upload.setDate(index + 1, (Date)field);
                        break;
                    }
                    case 92: {
                        upload.setTime(index + 1, (Time)field);
                        break;
                    }
                    case 93: {
                        upload.setTimestamp(index + 1, (Timestamp)field);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        upload.setBytes(index + 1, (byte[])field);
                        break;
                    }
                    default: {
                        upload.setObject(index + 1, field);
                        LOG.warn("Unmanaged sql type ({}) for column {}. Best effort approach to set its value: {}.", new Object[]{type, index + 1, field});
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                String errorMessage = String.format("%s, field index: %s, field value: %s.", e.getMessage(), index, field);
                ClassCastException enrichedException = new ClassCastException(errorMessage);
                enrichedException.setStackTrace(e.getStackTrace());
                throw enrichedException;
            }
        }
    }

    public static Row getPrimaryKey(Row row, int[] pkFields) {
        Row pkRow = new Row(pkFields.length);
        for (int i = 0; i < pkFields.length; ++i) {
            pkRow.setField(i, row.getField(pkFields[i]));
        }
        return pkRow;
    }
}

