/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public class GlobalCommitterTransform<CommT>
extends Transformation<Void> {
    private final DataStream<CommittableMessage<CommT>> inputStream;
    private final SerializableSupplier<Committer<CommT>> committerFactory;
    private final SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer;

    public GlobalCommitterTransform(DataStream<CommittableMessage<CommT>> inputStream, SerializableSupplier<Committer<CommT>> committerFactory, SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer) {
        super("Global Committer", Types.VOID, 1, true);
        this.inputStream = inputStream;
        this.committerFactory = committerFactory;
        this.committableSerializer = committableSerializer;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.inputStream.getTransformation().getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.inputStream.getTransformation());
    }

    public DataStream<CommittableMessage<CommT>> getInputStream() {
        return this.inputStream;
    }

    public SerializableSupplier<Committer<CommT>> getCommitterFactory() {
        return this.committerFactory;
    }

    public SerializableSupplier<SimpleVersionedSerializer<CommT>> getCommittableSerializer() {
        return this.committableSerializer;
    }
}

