/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.lionsoul.ip2region.xdb.InetAddressException;
import org.lionsoul.ip2region.xdb.LongByteArray;
import org.lionsoul.ip2region.xdb.Searcher;
import org.lionsoul.ip2region.xdb.Util;
import org.lionsoul.ip2region.xdb.Version;
import org.lionsoul.ip2region.xdb.XdbException;

public class SearchApp {
    public static void printHelp(String[] args) {
        System.out.print("ip2region xdb searcher\n");
        System.out.print("java -jar ip2region-{version}.jar [command] [command options]\n");
        System.out.print("Command: \n");
        System.out.print("  search    search input test\n");
        System.out.print("  bench     search bench test\n");
    }

    public static Searcher createSearcher(String dbPath, String cachePolicy) throws IOException, XdbException {
        RandomAccessFile handle = new RandomAccessFile(dbPath, "r");
        Searcher.verify(handle);
        Version version = Version.fromHeader(Searcher.loadHeader(handle));
        if ("file".equals(cachePolicy)) {
            return Searcher.newWithFileOnly(version, dbPath);
        }
        if ("vectorIndex".equals(cachePolicy)) {
            byte[] vIndex = Searcher.loadVectorIndexFromFile(dbPath);
            return Searcher.newWithVectorIndex(version, dbPath, vIndex);
        }
        if ("content".equals(cachePolicy)) {
            LongByteArray cBuff = Searcher.loadContentFromFile(dbPath);
            return Searcher.newWithBuffer(version, cBuff);
        }
        throw new IOException("invalid cache policy `" + cachePolicy + "`, options: file/vectorIndex/content");
    }

    public static void searchTest(String[] args) throws IOException, XdbException {
        String dbPath = "";
        String cachePolicy = "vectorIndex";
        for (String r : args) {
            if (r.length() < 5 || r.indexOf("--") != 0) continue;
            int sIdx = r.indexOf(61);
            if (sIdx < 0) {
                System.out.printf("missing = for args pair `%s`\n", r);
                return;
            }
            String key = r.substring(2, sIdx);
            String val = r.substring(sIdx + 1);
            if ("db".equals(key)) {
                dbPath = val;
                continue;
            }
            if ("cache-policy".equals(key)) {
                cachePolicy = val;
                continue;
            }
            System.out.printf("undefined option `%s`\n", r);
            return;
        }
        if (dbPath.isEmpty()) {
            System.out.print("java -jar ip2region-{version}.jar search [command options]\n");
            System.out.print("options:\n");
            System.out.print(" --db string              ip2region binary xdb file path\n");
            System.out.print(" --cache-policy string    cache policy: file/vectorIndex/content\n");
            return;
        }
        Searcher searcher = SearchApp.createSearcher(dbPath, cachePolicy);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.printf("ip2region xdb searcher test program\nsource xdb: %s (%s, %s)\ntype 'quit' to exit\n", dbPath, searcher.getIPVersion().name, cachePolicy);
        while (true) {
            System.out.print("ip2region>> ");
            String line = reader.readLine().trim();
            if (line.length() < 2) continue;
            if (line.equalsIgnoreCase("quit")) break;
            try {
                double sTime = System.nanoTime();
                String region = searcher.search(line);
                long cost = TimeUnit.NANOSECONDS.toMicros((long)((double)System.nanoTime() - sTime));
                System.out.printf("{region: %s, ioCount: %d, took: %d \u03bcs}\n", region, searcher.getIOCount(), cost);
            }
            catch (Exception e) {
                System.out.printf("{err: %s, ioCount: %d}\n", e, searcher.getIOCount());
            }
        }
        reader.close();
        searcher.close();
        System.out.println("searcher test program exited, thanks for trying");
    }

    public static void benchTest(String[] args) throws IOException, XdbException, InetAddressException {
        String line;
        String dbPath = "";
        String srcPath = "";
        String cachePolicy = "vectorIndex";
        for (String r : args) {
            if (r.length() < 5 || r.indexOf("--") != 0) continue;
            int sIdx = r.indexOf(61);
            if (sIdx < 0) {
                System.out.printf("missing = for args pair `%s`\n", r);
                return;
            }
            String key = r.substring(2, sIdx);
            String val = r.substring(sIdx + 1);
            if ("db".equals(key)) {
                dbPath = val;
                continue;
            }
            if ("src".equals(key)) {
                srcPath = val;
                continue;
            }
            if ("cache-policy".equals(key)) {
                cachePolicy = val;
                continue;
            }
            System.out.printf("undefined option `%s`\n", r);
            return;
        }
        if (dbPath.length() < 1 || srcPath.length() < 1) {
            System.out.print("java -jar ip2region-{version}.jar bench [command options]\n");
            System.out.print("options:\n");
            System.out.print(" --db string              ip2region binary xdb file path\n");
            System.out.print(" --src string             source ip text file path\n");
            System.out.print(" --cache-policy string    cache policy: file/vectorIndex/content\n");
            return;
        }
        Searcher searcher = SearchApp.createSearcher(dbPath, cachePolicy);
        long count = 0L;
        long costs = 0L;
        long tStart = System.nanoTime();
        Charset charset = Charset.forName("utf-8");
        FileInputStream fis = new FileInputStream(srcPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fis, charset));
        while ((line = reader.readLine()) != null) {
            byte[] eip;
            byte[] sip;
            String l = line.trim();
            String[] ps = l.split("\\|", 3);
            if (ps.length != 3) {
                reader.close();
                System.out.printf("invalid ip segment `%s`\n", l);
                return;
            }
            try {
                sip = Util.parseIP(ps[0]);
            }
            catch (Exception e) {
                reader.close();
                System.out.printf("check start ip `%s`: %s\n", ps[0], e);
                return;
            }
            try {
                eip = Util.parseIP(ps[1]);
            }
            catch (Exception e) {
                reader.close();
                System.out.printf("check end ip `%s`: %s\n", ps[1], e);
                return;
            }
            if (Util.ipCompare(sip, eip) > 0) {
                reader.close();
                System.out.printf("start ip(%s) should not be greater than end ip(%s)\n", ps[0], ps[1]);
                return;
            }
            for (byte[] ip : new byte[][]{sip, eip}) {
                long sTime = System.nanoTime();
                String region = searcher.search(ip);
                costs += System.nanoTime() - sTime;
                if (!ps[2].equals(region)) {
                    System.out.printf("failed search(%s) with (%s != %s)\n", Util.ipToString(ip), region, ps[2]);
                    reader.close();
                    return;
                }
                ++count;
            }
        }
        reader.close();
        searcher.close();
        long took = System.nanoTime() - tStart;
        System.out.printf("Bench finished, {cachePolicy: %s, total: %d, took: %ds, cost: %d \u03bcs/op}\n", cachePolicy, count, TimeUnit.NANOSECONDS.toSeconds(took), count == 0L ? 0L : TimeUnit.NANOSECONDS.toMicros(costs / count));
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            SearchApp.printHelp(args);
            return;
        }
        if ("search".equals(args[0])) {
            try {
                SearchApp.searchTest(args);
            }
            catch (Exception e) {
                System.out.printf("failed running search test: %s\n", e);
            }
        } else if ("bench".equals(args[0])) {
            try {
                SearchApp.benchTest(args);
            }
            catch (Exception e) {
                System.out.printf("fwailed running bench test: %s\n", e);
            }
        } else {
            SearchApp.printHelp(args);
        }
    }
}

