/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.lionsoul.ip2region.xdb.InetAddressException;

public class Util {
    public static byte[] parseIP(String ip) throws InetAddressException {
        try {
            return InetAddress.getByName(ip).getAddress();
        }
        catch (UnknownHostException e) {
            throw new InetAddressException("invalid ip address `" + ip + "`");
        }
    }

    public static String ipToString(byte[] ip) {
        if (ip.length != 4 && ip.length != 16) {
            return String.format("invalid-ip-address-length: %d", ip.length);
        }
        try {
            return InetAddress.getByAddress(ip).getHostAddress();
        }
        catch (UnknownHostException e) {
            return String.format("invalid-ip-address `%s`", Util.ipJoin(ip));
        }
    }

    public static String ipJoin(byte[] ip) {
        return Util.bytesToString(ip, 0, ip.length);
    }

    public static String bytesToString(byte[] buff, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(buff[offset + i] & 0xFF);
        }
        sb.append("]");
        return sb.toString();
    }

    public static int ipCompare(byte[] ip1, byte[] ip2) {
        return Util.ipSubCompare(ip1, ip2, 0);
    }

    public static int ipSubCompare(byte[] ip, byte[] buff, int offset) {
        for (int i = 0; i < ip.length; ++i) {
            int i1 = ip[i] & 0xFF;
            int i2 = buff[offset + i] & 0xFF;
            if (i1 < i2) {
                return -1;
            }
            if (i1 <= i2) continue;
            return 1;
        }
        return 0;
    }
}

