/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

import org.lionsoul.ip2region.xdb.Header;
import org.lionsoul.ip2region.xdb.IPv4;
import org.lionsoul.ip2region.xdb.IPv6;
import org.lionsoul.ip2region.xdb.XdbException;

public abstract class Version {
    public static final int IPv4VersionNo = 4;
    public static final int IPv6VersionNo = 6;
    public static final IPv4 IPv4 = new IPv4();
    public static final IPv6 IPv6 = new IPv6();
    public final int id;
    public final String name;
    public final int bytes;
    public final int segmentIndexSize;

    public Version(int id, String name, int bytes, int segmentIndexSize) {
        this.id = id;
        this.name = name;
        this.bytes = bytes;
        this.segmentIndexSize = segmentIndexSize;
    }

    public abstract int putBytes(byte[] var1, int var2, byte[] var3);

    public int ipCompare(byte[] ip1, byte[] ip2) {
        return this.ipSubCompare(ip1, ip2, 0);
    }

    public abstract int ipSubCompare(byte[] var1, byte[] var2, int var3);

    public static final Version fromName(String name) throws Exception {
        String n = name.toUpperCase();
        if (n.equals("V4") || n.equals("IPV4")) {
            return IPv4;
        }
        if (n.equals("V6") || n.equals("IPV6")) {
            return IPv6;
        }
        throw new Exception("invalid version name `" + name + "`");
    }

    public static final Version fromHeader(Header header) throws XdbException {
        if (header.version == 2) {
            return IPv4;
        }
        if (header.version != 3) {
            throw new XdbException("invalid xdb structure version `" + header.version + "`");
        }
        if (header.ipVersion == 4) {
            return IPv4;
        }
        if (header.ipVersion == 6) {
            return IPv6;
        }
        throw new XdbException("invalid ip version number `" + header.ipVersion + "`");
    }

    public String toString() {
        return String.format("{Id:%d, Name:%s, Bytes:%d, IndexSize: %d}", this.id, this.name, this.bytes, this.segmentIndexSize);
    }
}

