/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.util.HtmlUtils;

@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
@Configuration
public class ErrorMvcAutoConfiguration
implements EmbeddedServletContainerCustomizer {
    @Value(value="${error.path:/error}")
    private String errorPath = "/error";
    @Autowired
    private ServerProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public DefaultErrorAttributes errorAttributes() {
        return new DefaultErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BasicErrorController basicErrorController(ErrorAttributes errorAttributes) {
        return new BasicErrorController(errorAttributes);
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        container.addErrorPages(new ErrorPage[]{new ErrorPage(this.properties.getServletPrefix() + this.errorPath)});
    }

    private static class SpelPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final SpelExpressionParser parser = new SpelExpressionParser();
        private final StandardEvaluationContext context;

        public SpelPlaceholderResolver(StandardEvaluationContext context) {
            this.context = context;
        }

        public String resolvePlaceholder(String name) {
            Expression expression = this.parser.parseExpression(name);
            try {
                Object value = expression.getValue((EvaluationContext)this.context);
                return HtmlUtils.htmlEscape((String)(value == null ? null : value.toString()));
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private static class SpelView
    implements View {
        private final String template;
        private final StandardEvaluationContext context = new StandardEvaluationContext();
        private PropertyPlaceholderHelper helper;
        private PropertyPlaceholderHelper.PlaceholderResolver resolver;

        public SpelView(String template) {
            this.template = template;
            this.context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            this.helper = new PropertyPlaceholderHelper("${", "}");
            this.resolver = new SpelPlaceholderResolver(this.context);
        }

        public String getContentType() {
            return "text/html";
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (response.getContentType() == null) {
                response.setContentType(this.getContentType());
            }
            HashMap map = new HashMap(model);
            map.put("path", request.getContextPath());
            this.context.setRootObject(map);
            String result = this.helper.replacePlaceholders(this.template, this.resolver);
            response.getWriter().append(result);
        }
    }

    private static class ErrorTemplateMissingCondition
    extends SpringBootCondition {
        private ErrorTemplateMissingCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            List availabilityProviders = SpringFactoriesLoader.loadFactories(TemplateAvailabilityProvider.class, (ClassLoader)context.getClassLoader());
            for (TemplateAvailabilityProvider availabilityProvider : availabilityProviders) {
                if (!availabilityProvider.isTemplateAvailable("error", context.getEnvironment(), context.getClassLoader(), context.getResourceLoader())) continue;
                return ConditionOutcome.noMatch("Template from " + availabilityProvider + " found for error view");
            }
            return ConditionOutcome.match("No error template view detected");
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${error.whitelabel.enabled:true}")
    @Conditional(value={ErrorTemplateMissingCondition.class})
    protected static class WhitelabelErrorViewConfiguration {
        private final SpelView defaultErrorView = new SpelView("<html><body><h1>Whitelabel Error Page</h1><p>This application has no explicit mapping for /error, so you are seeing this as a fallback.</p><div id='created'>${timestamp}</div><div>There was an unexpected error (type=${error}, status=${status}).</div><div>${message}</div></body></html>");

        protected WhitelabelErrorViewConfiguration() {
        }

        @Bean(name={"error"})
        @ConditionalOnMissingBean(name={"error"})
        public View defaultErrorView() {
            return this.defaultErrorView;
        }

        @Bean
        @ConditionalOnMissingBean(value={BeanNameViewResolver.class})
        public BeanNameViewResolver beanNameViewResolver() {
            BeanNameViewResolver resolver = new BeanNameViewResolver();
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }
    }
}

