/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.NoSuchResourceException;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.util.UrlPathHelper;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class ResourceController {
    private ResourceRepository resourceRepository;
    private EnvironmentRepository environmentRepository;
    private UrlPathHelper helper = new UrlPathHelper();

    public ResourceController(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
        this.helper.setAlwaysUseFullPath(true);
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/**"})
    public String retrieve(@PathVariable String name, @PathVariable String profile, @PathVariable String label, ServletWebRequest request, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        String path = this.getFilePath(request, name, profile, label);
        return this.retrieve(request, name, profile, label, path, resolvePlaceholders);
    }

    @RequestMapping(value={"/{name}/{profile}/**"}, params={"useDefaultLabel"})
    public String retrieve(@PathVariable String name, @PathVariable String profile, ServletWebRequest request, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        String path = this.getFilePath(request, name, profile, null);
        return this.retrieve(request, name, profile, null, path, resolvePlaceholders);
    }

    private String getFilePath(ServletWebRequest request, String name, String profile, String label) {
        String stem = label != null ? String.format("/%s/%s/%s/", name, profile, label) : String.format("/%s/%s/", name, profile);
        String path = this.helper.getPathWithinApplication(request.getRequest());
        path = path.substring(path.indexOf(stem) + stem.length());
        return path;
    }

    synchronized String retrieve(ServletWebRequest request, String name, String profile, String label, String path, boolean resolvePlaceholders) throws IOException {
        Resource resource = this.resourceRepository.findOne(name = this.resolveName(name), profile, label = this.resolveLabel(label), path);
        if (this.checkNotModified(request, resource)) {
            return null;
        }
        try (InputStream is = resource.getInputStream();){
            String text = StreamUtils.copyToString((InputStream)is, (Charset)Charset.forName("UTF-8"));
            if (resolvePlaceholders) {
                Environment environment = this.environmentRepository.findOne(name, profile, label);
                text = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), text);
            }
            String string = text;
            return string;
        }
    }

    String retrieve(String name, String profile, String label, String path, boolean resolvePlaceholders) throws IOException {
        return this.retrieve(null, name, profile, label, path, resolvePlaceholders);
    }

    @RequestMapping(value={"/{name}/{profile}/{label}/**"}, produces={"application/octet-stream"})
    public synchronized byte[] binary(@PathVariable String name, @PathVariable String profile, @PathVariable String label, ServletWebRequest request) throws IOException {
        String path = this.getFilePath(request, name, profile, label);
        return this.binary(request, name, profile, label, path);
    }

    byte[] binary(String name, String profile, String label, String path) throws IOException {
        return this.binary(null, name, profile, label, path);
    }

    private synchronized byte[] binary(ServletWebRequest request, String name, String profile, String label, String path) throws IOException {
        Resource resource = this.resourceRepository.findOne(name = this.resolveName(name), profile, label = this.resolveLabel(label), path);
        if (this.checkNotModified(request, resource)) {
            return null;
        }
        EnvironmentPropertySource.prepareEnvironment(this.environmentRepository.findOne(name, profile, label));
        try (InputStream is = resource.getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }

    private boolean checkNotModified(ServletWebRequest request, Resource resource) {
        try {
            return request != null && request.checkNotModified(resource.lastModified());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String resolveName(String name) {
        if (name != null && name.contains("(_)")) {
            name = name.replace("(_)", "/");
        }
        return name;
    }

    private String resolveLabel(String label) {
        if (label != null && label.contains("(_)")) {
            label = label.replace("(_)", "/");
        }
        return label;
    }

    @ExceptionHandler(value={NoSuchResourceException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void notFound(NoSuchResourceException e) {
    }
}

