/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicy;
import software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratedPolicyResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeneratedPolicyResult> {
    private static final SdkField<List<GeneratedPolicy>> GENERATED_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("generatedPolicies").getter(GeneratedPolicyResult.getter(GeneratedPolicyResult::generatedPolicies)).setter(GeneratedPolicyResult.setter(Builder::generatedPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeneratedPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GeneratedPolicyProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("properties").getter(GeneratedPolicyResult.getter(GeneratedPolicyResult::properties)).setter(GeneratedPolicyResult.setter(Builder::properties)).constructor(GeneratedPolicyProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_POLICIES_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<GeneratedPolicy> generatedPolicies;
    private final GeneratedPolicyProperties properties;

    private GeneratedPolicyResult(BuilderImpl builder) {
        this.generatedPolicies = builder.generatedPolicies;
        this.properties = builder.properties;
    }

    public final boolean hasGeneratedPolicies() {
        return this.generatedPolicies != null && !(this.generatedPolicies instanceof SdkAutoConstructList);
    }

    public final List<GeneratedPolicy> generatedPolicies() {
        return this.generatedPolicies;
    }

    public final GeneratedPolicyProperties properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGeneratedPolicies() ? this.generatedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedPolicyResult)) {
            return false;
        }
        GeneratedPolicyResult other = (GeneratedPolicyResult)obj;
        return this.hasGeneratedPolicies() == other.hasGeneratedPolicies() && Objects.equals(this.generatedPolicies(), other.generatedPolicies()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratedPolicyResult").add("GeneratedPolicies", this.hasGeneratedPolicies() ? this.generatedPolicies() : null).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "generatedPolicies": {
                return Optional.ofNullable(clazz.cast(this.generatedPolicies()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratedPolicyResult, T> g) {
        return obj -> g.apply((GeneratedPolicyResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GeneratedPolicy> generatedPolicies = DefaultSdkAutoConstructList.getInstance();
        private GeneratedPolicyProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedPolicyResult model) {
            this.generatedPolicies(model.generatedPolicies);
            this.properties(model.properties);
        }

        public final List<GeneratedPolicy.Builder> getGeneratedPolicies() {
            List<GeneratedPolicy.Builder> result = GeneratedPolicyListCopier.copyToBuilder(this.generatedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedPolicies(Collection<GeneratedPolicy.BuilderImpl> generatedPolicies) {
            this.generatedPolicies = GeneratedPolicyListCopier.copyFromBuilder(generatedPolicies);
        }

        @Override
        @Transient
        public final Builder generatedPolicies(Collection<GeneratedPolicy> generatedPolicies) {
            this.generatedPolicies = GeneratedPolicyListCopier.copy(generatedPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder generatedPolicies(GeneratedPolicy ... generatedPolicies) {
            this.generatedPolicies(Arrays.asList(generatedPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder generatedPolicies(Consumer<GeneratedPolicy.Builder> ... generatedPolicies) {
            this.generatedPolicies(Stream.of(generatedPolicies).map(c -> (GeneratedPolicy)((GeneratedPolicy.Builder)GeneratedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GeneratedPolicyProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(GeneratedPolicyProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        @Transient
        public final Builder properties(GeneratedPolicyProperties properties) {
            this.properties = properties;
            return this;
        }

        public GeneratedPolicyResult build() {
            return new GeneratedPolicyResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeneratedPolicyResult> {
        public Builder generatedPolicies(Collection<GeneratedPolicy> var1);

        public Builder generatedPolicies(GeneratedPolicy ... var1);

        public Builder generatedPolicies(Consumer<GeneratedPolicy.Builder> ... var1);

        public Builder properties(GeneratedPolicyProperties var1);

        default public Builder properties(Consumer<GeneratedPolicyProperties.Builder> properties) {
            return this.properties((GeneratedPolicyProperties)((GeneratedPolicyProperties.Builder)GeneratedPolicyProperties.builder().applyMutation(properties)).build());
        }
    }
}

