/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsCertificate;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsMode;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsValidationContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListenerTls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListenerTls> {
    private static final SdkField<ListenerTlsCertificate> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificate").getter(ListenerTls.getter(ListenerTls::certificate)).setter(ListenerTls.setter(Builder::certificate)).constructor(ListenerTlsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(ListenerTls.getter(ListenerTls::modeAsString)).setter(ListenerTls.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<ListenerTlsValidationContext> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validation").getter(ListenerTls.getter(ListenerTls::validation)).setter(ListenerTls.setter(Builder::validation)).constructor(ListenerTlsValidationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, MODE_FIELD, VALIDATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ListenerTlsCertificate certificate;
    private final String mode;
    private final ListenerTlsValidationContext validation;

    private ListenerTls(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.mode = builder.mode;
        this.validation = builder.validation;
    }

    public final ListenerTlsCertificate certificate() {
        return this.certificate;
    }

    public final ListenerTlsMode mode() {
        return ListenerTlsMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final ListenerTlsValidationContext validation() {
        return this.validation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTls)) {
            return false;
        }
        ListenerTls other = (ListenerTls)obj;
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.validation(), other.validation());
    }

    public final String toString() {
        return ToString.builder((String)"ListenerTls").add("Certificate", (Object)this.certificate()).add("Mode", (Object)this.modeAsString()).add("Validation", (Object)this.validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerTls, T> g) {
        return obj -> g.apply((ListenerTls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ListenerTlsCertificate certificate;
        private String mode;
        private ListenerTlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTls model) {
            this.certificate(model.certificate);
            this.mode(model.mode);
            this.validation(model.validation);
        }

        public final ListenerTlsCertificate.Builder getCertificate() {
            return this.certificate != null ? this.certificate.toBuilder() : null;
        }

        public final void setCertificate(ListenerTlsCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        @Override
        @Transient
        public final Builder certificate(ListenerTlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @Transient
        public final Builder mode(ListenerTlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final ListenerTlsValidationContext.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        public final void setValidation(ListenerTlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        @Transient
        public final Builder validation(ListenerTlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        public ListenerTls build() {
            return new ListenerTls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListenerTls> {
        public Builder certificate(ListenerTlsCertificate var1);

        default public Builder certificate(Consumer<ListenerTlsCertificate.Builder> certificate) {
            return this.certificate((ListenerTlsCertificate)((ListenerTlsCertificate.Builder)ListenerTlsCertificate.builder().applyMutation(certificate)).build());
        }

        public Builder mode(String var1);

        public Builder mode(ListenerTlsMode var1);

        public Builder validation(ListenerTlsValidationContext var1);

        default public Builder validation(Consumer<ListenerTlsValidationContext.Builder> validation) {
            return this.validation((ListenerTlsValidationContext)((ListenerTlsValidationContext.Builder)ListenerTlsValidationContext.builder().applyMutation(validation)).build());
        }
    }
}

