/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.Duration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutlierDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutlierDetection> {
    private static final SdkField<Duration> BASE_EJECTION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("baseEjectionDuration").getter(OutlierDetection.getter(OutlierDetection::baseEjectionDuration)).setter(OutlierDetection.setter(Builder::baseEjectionDuration)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseEjectionDuration").build()}).build();
    private static final SdkField<Duration> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("interval").getter(OutlierDetection.getter(OutlierDetection::interval)).setter(OutlierDetection.setter(Builder::interval)).constructor(Duration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interval").build()}).build();
    private static final SdkField<Integer> MAX_EJECTION_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxEjectionPercent").getter(OutlierDetection.getter(OutlierDetection::maxEjectionPercent)).setter(OutlierDetection.setter(Builder::maxEjectionPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxEjectionPercent").build()}).build();
    private static final SdkField<Long> MAX_SERVER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maxServerErrors").getter(OutlierDetection.getter(OutlierDetection::maxServerErrors)).setter(OutlierDetection.setter(Builder::maxServerErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxServerErrors").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_EJECTION_DURATION_FIELD, INTERVAL_FIELD, MAX_EJECTION_PERCENT_FIELD, MAX_SERVER_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Duration baseEjectionDuration;
    private final Duration interval;
    private final Integer maxEjectionPercent;
    private final Long maxServerErrors;

    private OutlierDetection(BuilderImpl builder) {
        this.baseEjectionDuration = builder.baseEjectionDuration;
        this.interval = builder.interval;
        this.maxEjectionPercent = builder.maxEjectionPercent;
        this.maxServerErrors = builder.maxServerErrors;
    }

    public final Duration baseEjectionDuration() {
        return this.baseEjectionDuration;
    }

    public final Duration interval() {
        return this.interval;
    }

    public final Integer maxEjectionPercent() {
        return this.maxEjectionPercent;
    }

    public final Long maxServerErrors() {
        return this.maxServerErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEjectionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEjectionPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxServerErrors());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutlierDetection)) {
            return false;
        }
        OutlierDetection other = (OutlierDetection)obj;
        return Objects.equals(this.baseEjectionDuration(), other.baseEjectionDuration()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.maxEjectionPercent(), other.maxEjectionPercent()) && Objects.equals(this.maxServerErrors(), other.maxServerErrors());
    }

    public final String toString() {
        return ToString.builder((String)"OutlierDetection").add("BaseEjectionDuration", (Object)this.baseEjectionDuration()).add("Interval", (Object)this.interval()).add("MaxEjectionPercent", (Object)this.maxEjectionPercent()).add("MaxServerErrors", (Object)this.maxServerErrors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseEjectionDuration": {
                return Optional.ofNullable(clazz.cast(this.baseEjectionDuration()));
            }
            case "interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "maxEjectionPercent": {
                return Optional.ofNullable(clazz.cast(this.maxEjectionPercent()));
            }
            case "maxServerErrors": {
                return Optional.ofNullable(clazz.cast(this.maxServerErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutlierDetection, T> g) {
        return obj -> g.apply((OutlierDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Duration baseEjectionDuration;
        private Duration interval;
        private Integer maxEjectionPercent;
        private Long maxServerErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(OutlierDetection model) {
            this.baseEjectionDuration(model.baseEjectionDuration);
            this.interval(model.interval);
            this.maxEjectionPercent(model.maxEjectionPercent);
            this.maxServerErrors(model.maxServerErrors);
        }

        public final Duration.Builder getBaseEjectionDuration() {
            return this.baseEjectionDuration != null ? this.baseEjectionDuration.toBuilder() : null;
        }

        public final void setBaseEjectionDuration(Duration.BuilderImpl baseEjectionDuration) {
            this.baseEjectionDuration = baseEjectionDuration != null ? baseEjectionDuration.build() : null;
        }

        @Override
        @Transient
        public final Builder baseEjectionDuration(Duration baseEjectionDuration) {
            this.baseEjectionDuration = baseEjectionDuration;
            return this;
        }

        public final Duration.Builder getInterval() {
            return this.interval != null ? this.interval.toBuilder() : null;
        }

        public final void setInterval(Duration.BuilderImpl interval) {
            this.interval = interval != null ? interval.build() : null;
        }

        @Override
        @Transient
        public final Builder interval(Duration interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getMaxEjectionPercent() {
            return this.maxEjectionPercent;
        }

        public final void setMaxEjectionPercent(Integer maxEjectionPercent) {
            this.maxEjectionPercent = maxEjectionPercent;
        }

        @Override
        @Transient
        public final Builder maxEjectionPercent(Integer maxEjectionPercent) {
            this.maxEjectionPercent = maxEjectionPercent;
            return this;
        }

        public final Long getMaxServerErrors() {
            return this.maxServerErrors;
        }

        public final void setMaxServerErrors(Long maxServerErrors) {
            this.maxServerErrors = maxServerErrors;
        }

        @Override
        @Transient
        public final Builder maxServerErrors(Long maxServerErrors) {
            this.maxServerErrors = maxServerErrors;
            return this;
        }

        public OutlierDetection build() {
            return new OutlierDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutlierDetection> {
        public Builder baseEjectionDuration(Duration var1);

        default public Builder baseEjectionDuration(Consumer<Duration.Builder> baseEjectionDuration) {
            return this.baseEjectionDuration((Duration)((Duration.Builder)Duration.builder().applyMutation(baseEjectionDuration)).build());
        }

        public Builder interval(Duration var1);

        default public Builder interval(Consumer<Duration.Builder> interval) {
            return this.interval((Duration)((Duration.Builder)Duration.builder().applyMutation(interval)).build());
        }

        public Builder maxEjectionPercent(Integer var1);

        public Builder maxServerErrors(Long var1);
    }
}

