/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.CEType;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputeEnvironmentRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, CreateComputeEnvironmentRequest> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironmentName").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::computeEnvironmentName)).setter(CreateComputeEnvironmentRequest.setter(Builder::computeEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::typeAsString)).setter(CreateComputeEnvironmentRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::stateAsString)).setter(CreateComputeEnvironmentRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Integer> UNMANAGEDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("unmanagedvCpus").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::unmanagedvCpus)).setter(CreateComputeEnvironmentRequest.setter(Builder::unmanagedvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmanagedvCpus").build()}).build();
    private static final SdkField<ComputeResource> COMPUTE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeResources").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::computeResources)).setter(CreateComputeEnvironmentRequest.setter(Builder::computeResources)).constructor(ComputeResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeResources").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::serviceRole)).setter(CreateComputeEnvironmentRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateComputeEnvironmentRequest.getter(CreateComputeEnvironmentRequest::tags)).setter(CreateComputeEnvironmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENT_NAME_FIELD, TYPE_FIELD, STATE_FIELD, UNMANAGEDV_CPUS_FIELD, COMPUTE_RESOURCES_FIELD, SERVICE_ROLE_FIELD, TAGS_FIELD));
    private final String computeEnvironmentName;
    private final String type;
    private final String state;
    private final Integer unmanagedvCpus;
    private final ComputeResource computeResources;
    private final String serviceRole;
    private final Map<String, String> tags;

    private CreateComputeEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.type = builder.type;
        this.state = builder.state;
        this.unmanagedvCpus = builder.unmanagedvCpus;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
        this.tags = builder.tags;
    }

    public final String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public final CEType type() {
        return CEType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CEState state() {
        return CEState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer unmanagedvCpus() {
        return this.unmanagedvCpus;
    }

    public final ComputeResource computeResources() {
        return this.computeResources;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmanagedvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentRequest)) {
            return false;
        }
        CreateComputeEnvironmentRequest other = (CreateComputeEnvironmentRequest)((Object)obj);
        return Objects.equals(this.computeEnvironmentName(), other.computeEnvironmentName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.unmanagedvCpus(), other.unmanagedvCpus()) && Objects.equals(this.computeResources(), other.computeResources()) && Objects.equals(this.serviceRole(), other.serviceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComputeEnvironmentRequest").add("ComputeEnvironmentName", (Object)this.computeEnvironmentName()).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("UnmanagedvCpus", (Object)this.unmanagedvCpus()).add("ComputeResources", (Object)this.computeResources()).add("ServiceRole", (Object)this.serviceRole()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironmentName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "unmanagedvCpus": {
                return Optional.ofNullable(clazz.cast(this.unmanagedvCpus()));
            }
            case "computeResources": {
                return Optional.ofNullable(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateComputeEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String type;
        private String state;
        private Integer unmanagedvCpus;
        private ComputeResource computeResources;
        private String serviceRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentRequest model) {
            super(model);
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.type(model.type);
            this.state(model.state);
            this.unmanagedvCpus(model.unmanagedvCpus);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
            this.tags(model.tags);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        @Override
        @Transient
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(CEType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CEState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getUnmanagedvCpus() {
            return this.unmanagedvCpus;
        }

        public final void setUnmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
        }

        @Override
        @Transient
        public final Builder unmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        public final ComputeResource.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        @Override
        @Transient
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputeEnvironmentRequest build() {
            return new CreateComputeEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputeEnvironmentRequest> {
        public Builder computeEnvironmentName(String var1);

        public Builder type(String var1);

        public Builder type(CEType var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder unmanagedvCpus(Integer var1);

        public Builder computeResources(ComputeResource var1);

        default public Builder computeResources(Consumer<ComputeResource.Builder> computeResources) {
            return this.computeResources((ComputeResource)((ComputeResource.Builder)ComputeResource.builder().applyMutation(computeResources)).build());
        }

        public Builder serviceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

