/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.services.config.model.ConformancePackConfigRuleNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackComplianceFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackComplianceFilters> {
    private static final SdkField<List<String>> CONFIG_RULE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigRuleNames").getter(ConformancePackComplianceFilters.getter(ConformancePackComplianceFilters::configRuleNames)).setter(ConformancePackComplianceFilters.setter(Builder::configRuleNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(ConformancePackComplianceFilters.getter(ConformancePackComplianceFilters::complianceTypeAsString)).setter(ConformancePackComplianceFilters.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAMES_FIELD, COMPLIANCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> configRuleNames;
    private final String complianceType;

    private ConformancePackComplianceFilters(BuilderImpl builder) {
        this.configRuleNames = builder.configRuleNames;
        this.complianceType = builder.complianceType;
    }

    public final boolean hasConfigRuleNames() {
        return this.configRuleNames != null && !(this.configRuleNames instanceof SdkAutoConstructList);
    }

    public final List<String> configRuleNames() {
        return this.configRuleNames;
    }

    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigRuleNames() ? this.configRuleNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackComplianceFilters)) {
            return false;
        }
        ConformancePackComplianceFilters other = (ConformancePackComplianceFilters)obj;
        return this.hasConfigRuleNames() == other.hasConfigRuleNames() && Objects.equals(this.configRuleNames(), other.configRuleNames()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConformancePackComplianceFilters").add("ConfigRuleNames", this.hasConfigRuleNames() ? this.configRuleNames() : null).add("ComplianceType", (Object)this.complianceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigRuleNames": {
                return Optional.ofNullable(clazz.cast(this.configRuleNames()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackComplianceFilters, T> g) {
        return obj -> g.apply((ConformancePackComplianceFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> configRuleNames = DefaultSdkAutoConstructList.getInstance();
        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackComplianceFilters model) {
            this.configRuleNames(model.configRuleNames);
            this.complianceType(model.complianceType);
        }

        public final Collection<String> getConfigRuleNames() {
            if (this.configRuleNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configRuleNames;
        }

        public final void setConfigRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
        }

        @Override
        @Transient
        public final Builder configRuleNames(Collection<String> configRuleNames) {
            this.configRuleNames = ConformancePackConfigRuleNamesCopier.copy(configRuleNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configRuleNames(String ... configRuleNames) {
            this.configRuleNames(Arrays.asList(configRuleNames));
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        @Transient
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        @Transient
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public ConformancePackComplianceFilters build() {
            return new ConformancePackComplianceFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackComplianceFilters> {
        public Builder configRuleNames(Collection<String> var1);

        public Builder configRuleNames(String ... var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ConformancePackComplianceType var1);
    }
}

