/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Owner {
    CUSTOM_LAMBDA("CUSTOM_LAMBDA"),
    AWS("AWS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Owner> VALUE_MAP;
    private final String value;

    private Owner(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Owner fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Owner> knownValues() {
        EnumSet<Owner> knownValues = EnumSet.allOf(Owner.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Owner.class, Owner::toString);
    }
}

