/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.ResourceKey;
import software.amazon.awssdk.services.config.model.ResourceKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRemediationExecutionResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, StartRemediationExecutionResponse> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(StartRemediationExecutionResponse.getter(StartRemediationExecutionResponse::failureMessage)).setter(StartRemediationExecutionResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<List<ResourceKey>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedItems").getter(StartRemediationExecutionResponse.getter(StartRemediationExecutionResponse::failedItems)).setter(StartRemediationExecutionResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD, FAILED_ITEMS_FIELD));
    private final String failureMessage;
    private final List<ResourceKey> failedItems;

    private StartRemediationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.failureMessage = builder.failureMessage;
        this.failedItems = builder.failedItems;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructList);
    }

    public final List<ResourceKey> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemediationExecutionResponse)) {
            return false;
        }
        StartRemediationExecutionResponse other = (StartRemediationExecutionResponse)((Object)obj);
        return Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"StartRemediationExecutionResponse").add("FailureMessage", (Object)this.failureMessage()).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "FailedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRemediationExecutionResponse, T> g) {
        return obj -> g.apply((StartRemediationExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private String failureMessage;
        private List<ResourceKey> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemediationExecutionResponse model) {
            super(model);
            this.failureMessage(model.failureMessage);
            this.failedItems(model.failedItems);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        @Transient
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<ResourceKey.Builder> getFailedItems() {
            List<ResourceKey.Builder> result = ResourceKeysCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Collection<ResourceKey.BuilderImpl> failedItems) {
            this.failedItems = ResourceKeysCopier.copyFromBuilder(failedItems);
        }

        @Override
        @Transient
        public final Builder failedItems(Collection<ResourceKey> failedItems) {
            this.failedItems = ResourceKeysCopier.copy(failedItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedItems(ResourceKey ... failedItems) {
            this.failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedItems(Consumer<ResourceKey.Builder> ... failedItems) {
            this.failedItems(Stream.of(failedItems).map(c -> (ResourceKey)((ResourceKey.Builder)ResourceKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartRemediationExecutionResponse build() {
            return new StartRemediationExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRemediationExecutionResponse> {
        public Builder failureMessage(String var1);

        public Builder failedItems(Collection<ResourceKey> var1);

        public Builder failedItems(ResourceKey ... var1);

        public Builder failedItems(Consumer<ResourceKey.Builder> ... var1);
    }
}

