/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ResourceIdentifier;

public class ListDiscoveredResourcesIterable
implements SdkIterable<ListDiscoveredResourcesResponse> {
    private final ConfigClient client;
    private final ListDiscoveredResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDiscoveredResourcesIterable(ConfigClient client, ListDiscoveredResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDiscoveredResourcesResponseFetcher();
    }

    public Iterator<ListDiscoveredResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceIdentifier> resourceIdentifiers() {
        Function<ListDiscoveredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDiscoveredResourcesResponseFetcher
    implements SyncPageFetcher<ListDiscoveredResourcesResponse> {
        private ListDiscoveredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDiscoveredResourcesResponse nextPage(ListDiscoveredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveredResourcesIterable.this.client.listDiscoveredResources(ListDiscoveredResourcesIterable.this.firstRequest);
            }
            return ListDiscoveredResourcesIterable.this.client.listDiscoveredResources((ListDiscoveredResourcesRequest)((Object)ListDiscoveredResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

