/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactFlowState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactFlowMetadataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateContactFlowMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateContactFlowMetadataRequest.getter(UpdateContactFlowMetadataRequest::instanceId)).setter(UpdateContactFlowMetadataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(UpdateContactFlowMetadataRequest.getter(UpdateContactFlowMetadataRequest::contactFlowId)).setter(UpdateContactFlowMetadataRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateContactFlowMetadataRequest.getter(UpdateContactFlowMetadataRequest::name)).setter(UpdateContactFlowMetadataRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateContactFlowMetadataRequest.getter(UpdateContactFlowMetadataRequest::description)).setter(UpdateContactFlowMetadataRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowState").getter(UpdateContactFlowMetadataRequest.getter(UpdateContactFlowMetadataRequest::contactFlowStateAsString)).setter(UpdateContactFlowMetadataRequest.setter(Builder::contactFlowState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_FLOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONTACT_FLOW_STATE_FIELD));
    private final String instanceId;
    private final String contactFlowId;
    private final String name;
    private final String description;
    private final String contactFlowState;

    private UpdateContactFlowMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowId = builder.contactFlowId;
        this.name = builder.name;
        this.description = builder.description;
        this.contactFlowState = builder.contactFlowState;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ContactFlowState contactFlowState() {
        return ContactFlowState.fromValue(this.contactFlowState);
    }

    public final String contactFlowStateAsString() {
        return this.contactFlowState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactFlowMetadataRequest)) {
            return false;
        }
        UpdateContactFlowMetadataRequest other = (UpdateContactFlowMetadataRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.contactFlowStateAsString(), other.contactFlowStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContactFlowMetadataRequest").add("InstanceId", (Object)this.instanceId()).add("ContactFlowId", (Object)this.contactFlowId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ContactFlowState", (Object)this.contactFlowStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ContactFlowState": {
                return Optional.ofNullable(clazz.cast(this.contactFlowStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactFlowMetadataRequest, T> g) {
        return obj -> g.apply((UpdateContactFlowMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactFlowId;
        private String name;
        private String description;
        private String contactFlowState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactFlowMetadataRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactFlowId(model.contactFlowId);
            this.name(model.name);
            this.description(model.description);
            this.contactFlowState(model.contactFlowState);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        @Transient
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowState() {
            return this.contactFlowState;
        }

        public final void setContactFlowState(String contactFlowState) {
            this.contactFlowState = contactFlowState;
        }

        @Override
        @Transient
        public final Builder contactFlowState(String contactFlowState) {
            this.contactFlowState = contactFlowState;
            return this;
        }

        @Override
        @Transient
        public final Builder contactFlowState(ContactFlowState contactFlowState) {
            this.contactFlowState(contactFlowState == null ? null : contactFlowState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactFlowMetadataRequest build() {
            return new UpdateContactFlowMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactFlowMetadataRequest> {
        public Builder instanceId(String var1);

        public Builder contactFlowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder contactFlowState(String var1);

        public Builder contactFlowState(ContactFlowState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

