/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.QueueStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQueueStatusRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateQueueStatusRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateQueueStatusRequest.getter(UpdateQueueStatusRequest::instanceId)).setter(UpdateQueueStatusRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(UpdateQueueStatusRequest.getter(UpdateQueueStatusRequest::queueId)).setter(UpdateQueueStatusRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("QueueId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateQueueStatusRequest.getter(UpdateQueueStatusRequest::statusAsString)).setter(UpdateQueueStatusRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, QUEUE_ID_FIELD, STATUS_FIELD));
    private final String instanceId;
    private final String queueId;
    private final String status;

    private UpdateQueueStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.queueId = builder.queueId;
        this.status = builder.status;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueStatusRequest)) {
            return false;
        }
        UpdateQueueStatusRequest other = (UpdateQueueStatusRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQueueStatusRequest").add("InstanceId", (Object)this.instanceId()).add("QueueId", (Object)this.queueId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueStatusRequest, T> g) {
        return obj -> g.apply((UpdateQueueStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String queueId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueStatusRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.queueId(model.queueId);
            this.status(model.status);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        @Transient
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueStatusRequest build() {
            return new UpdateQueueStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQueueStatusRequest> {
        public Builder instanceId(String var1);

        public Builder queueId(String var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

