/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.ColumnSelector;
import software.amazon.awssdk.services.databrew.model.ColumnSelectorListCopier;
import software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfiguration;
import software.amazon.awssdk.services.databrew.model.ColumnStatisticsConfigurationListCopier;
import software.amazon.awssdk.services.databrew.model.EntityDetectorConfiguration;
import software.amazon.awssdk.services.databrew.model.StatisticsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileConfiguration> {
    private static final SdkField<StatisticsConfiguration> DATASET_STATISTICS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetStatisticsConfiguration").getter(ProfileConfiguration.getter(ProfileConfiguration::datasetStatisticsConfiguration)).setter(ProfileConfiguration.setter(Builder::datasetStatisticsConfiguration)).constructor(StatisticsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetStatisticsConfiguration").build()}).build();
    private static final SdkField<List<ColumnSelector>> PROFILE_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileColumns").getter(ProfileConfiguration.getter(ProfileConfiguration::profileColumns)).setter(ProfileConfiguration.setter(Builder::profileColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnStatisticsConfiguration>> COLUMN_STATISTICS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnStatisticsConfigurations").getter(ProfileConfiguration.getter(ProfileConfiguration::columnStatisticsConfigurations)).setter(ProfileConfiguration.setter(Builder::columnStatisticsConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnStatisticsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EntityDetectorConfiguration> ENTITY_DETECTOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityDetectorConfiguration").getter(ProfileConfiguration.getter(ProfileConfiguration::entityDetectorConfiguration)).setter(ProfileConfiguration.setter(Builder::entityDetectorConfiguration)).constructor(EntityDetectorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityDetectorConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_STATISTICS_CONFIGURATION_FIELD, PROFILE_COLUMNS_FIELD, COLUMN_STATISTICS_CONFIGURATIONS_FIELD, ENTITY_DETECTOR_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final StatisticsConfiguration datasetStatisticsConfiguration;
    private final List<ColumnSelector> profileColumns;
    private final List<ColumnStatisticsConfiguration> columnStatisticsConfigurations;
    private final EntityDetectorConfiguration entityDetectorConfiguration;

    private ProfileConfiguration(BuilderImpl builder) {
        this.datasetStatisticsConfiguration = builder.datasetStatisticsConfiguration;
        this.profileColumns = builder.profileColumns;
        this.columnStatisticsConfigurations = builder.columnStatisticsConfigurations;
        this.entityDetectorConfiguration = builder.entityDetectorConfiguration;
    }

    public final StatisticsConfiguration datasetStatisticsConfiguration() {
        return this.datasetStatisticsConfiguration;
    }

    public final boolean hasProfileColumns() {
        return this.profileColumns != null && !(this.profileColumns instanceof SdkAutoConstructList);
    }

    public final List<ColumnSelector> profileColumns() {
        return this.profileColumns;
    }

    public final boolean hasColumnStatisticsConfigurations() {
        return this.columnStatisticsConfigurations != null && !(this.columnStatisticsConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ColumnStatisticsConfiguration> columnStatisticsConfigurations() {
        return this.columnStatisticsConfigurations;
    }

    public final EntityDetectorConfiguration entityDetectorConfiguration() {
        return this.entityDetectorConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetStatisticsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileColumns() ? this.profileColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnStatisticsConfigurations() ? this.columnStatisticsConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.entityDetectorConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)obj;
        return Objects.equals(this.datasetStatisticsConfiguration(), other.datasetStatisticsConfiguration()) && this.hasProfileColumns() == other.hasProfileColumns() && Objects.equals(this.profileColumns(), other.profileColumns()) && this.hasColumnStatisticsConfigurations() == other.hasColumnStatisticsConfigurations() && Objects.equals(this.columnStatisticsConfigurations(), other.columnStatisticsConfigurations()) && Objects.equals(this.entityDetectorConfiguration(), other.entityDetectorConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileConfiguration").add("DatasetStatisticsConfiguration", (Object)this.datasetStatisticsConfiguration()).add("ProfileColumns", this.hasProfileColumns() ? this.profileColumns() : null).add("ColumnStatisticsConfigurations", this.hasColumnStatisticsConfigurations() ? this.columnStatisticsConfigurations() : null).add("EntityDetectorConfiguration", (Object)this.entityDetectorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetStatisticsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.datasetStatisticsConfiguration()));
            }
            case "ProfileColumns": {
                return Optional.ofNullable(clazz.cast(this.profileColumns()));
            }
            case "ColumnStatisticsConfigurations": {
                return Optional.ofNullable(clazz.cast(this.columnStatisticsConfigurations()));
            }
            case "EntityDetectorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.entityDetectorConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileConfiguration, T> g) {
        return obj -> g.apply((ProfileConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StatisticsConfiguration datasetStatisticsConfiguration;
        private List<ColumnSelector> profileColumns = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnStatisticsConfiguration> columnStatisticsConfigurations = DefaultSdkAutoConstructList.getInstance();
        private EntityDetectorConfiguration entityDetectorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileConfiguration model) {
            this.datasetStatisticsConfiguration(model.datasetStatisticsConfiguration);
            this.profileColumns(model.profileColumns);
            this.columnStatisticsConfigurations(model.columnStatisticsConfigurations);
            this.entityDetectorConfiguration(model.entityDetectorConfiguration);
        }

        public final StatisticsConfiguration.Builder getDatasetStatisticsConfiguration() {
            return this.datasetStatisticsConfiguration != null ? this.datasetStatisticsConfiguration.toBuilder() : null;
        }

        public final void setDatasetStatisticsConfiguration(StatisticsConfiguration.BuilderImpl datasetStatisticsConfiguration) {
            this.datasetStatisticsConfiguration = datasetStatisticsConfiguration != null ? datasetStatisticsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder datasetStatisticsConfiguration(StatisticsConfiguration datasetStatisticsConfiguration) {
            this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
            return this;
        }

        public final List<ColumnSelector.Builder> getProfileColumns() {
            List<ColumnSelector.Builder> result = ColumnSelectorListCopier.copyToBuilder(this.profileColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileColumns(Collection<ColumnSelector.BuilderImpl> profileColumns) {
            this.profileColumns = ColumnSelectorListCopier.copyFromBuilder(profileColumns);
        }

        @Override
        @Transient
        public final Builder profileColumns(Collection<ColumnSelector> profileColumns) {
            this.profileColumns = ColumnSelectorListCopier.copy(profileColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder profileColumns(ColumnSelector ... profileColumns) {
            this.profileColumns(Arrays.asList(profileColumns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder profileColumns(Consumer<ColumnSelector.Builder> ... profileColumns) {
            this.profileColumns(Stream.of(profileColumns).map(c -> (ColumnSelector)((ColumnSelector.Builder)ColumnSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnStatisticsConfiguration.Builder> getColumnStatisticsConfigurations() {
            List<ColumnStatisticsConfiguration.Builder> result = ColumnStatisticsConfigurationListCopier.copyToBuilder(this.columnStatisticsConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnStatisticsConfigurations(Collection<ColumnStatisticsConfiguration.BuilderImpl> columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations = ColumnStatisticsConfigurationListCopier.copyFromBuilder(columnStatisticsConfigurations);
        }

        @Override
        @Transient
        public final Builder columnStatisticsConfigurations(Collection<ColumnStatisticsConfiguration> columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations = ColumnStatisticsConfigurationListCopier.copy(columnStatisticsConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnStatisticsConfigurations(ColumnStatisticsConfiguration ... columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations(Arrays.asList(columnStatisticsConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnStatisticsConfigurations(Consumer<ColumnStatisticsConfiguration.Builder> ... columnStatisticsConfigurations) {
            this.columnStatisticsConfigurations(Stream.of(columnStatisticsConfigurations).map(c -> (ColumnStatisticsConfiguration)((ColumnStatisticsConfiguration.Builder)ColumnStatisticsConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EntityDetectorConfiguration.Builder getEntityDetectorConfiguration() {
            return this.entityDetectorConfiguration != null ? this.entityDetectorConfiguration.toBuilder() : null;
        }

        public final void setEntityDetectorConfiguration(EntityDetectorConfiguration.BuilderImpl entityDetectorConfiguration) {
            this.entityDetectorConfiguration = entityDetectorConfiguration != null ? entityDetectorConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder entityDetectorConfiguration(EntityDetectorConfiguration entityDetectorConfiguration) {
            this.entityDetectorConfiguration = entityDetectorConfiguration;
            return this;
        }

        public ProfileConfiguration build() {
            return new ProfileConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileConfiguration> {
        public Builder datasetStatisticsConfiguration(StatisticsConfiguration var1);

        default public Builder datasetStatisticsConfiguration(Consumer<StatisticsConfiguration.Builder> datasetStatisticsConfiguration) {
            return this.datasetStatisticsConfiguration((StatisticsConfiguration)((StatisticsConfiguration.Builder)StatisticsConfiguration.builder().applyMutation(datasetStatisticsConfiguration)).build());
        }

        public Builder profileColumns(Collection<ColumnSelector> var1);

        public Builder profileColumns(ColumnSelector ... var1);

        public Builder profileColumns(Consumer<ColumnSelector.Builder> ... var1);

        public Builder columnStatisticsConfigurations(Collection<ColumnStatisticsConfiguration> var1);

        public Builder columnStatisticsConfigurations(ColumnStatisticsConfiguration ... var1);

        public Builder columnStatisticsConfigurations(Consumer<ColumnStatisticsConfiguration.Builder> ... var1);

        public Builder entityDetectorConfiguration(EntityDetectorConfiguration var1);

        default public Builder entityDetectorConfiguration(Consumer<EntityDetectorConfiguration.Builder> entityDetectorConfiguration) {
            return this.entityDetectorConfiguration((EntityDetectorConfiguration)((EntityDetectorConfiguration.Builder)EntityDetectorConfiguration.builder().applyMutation(entityDetectorConfiguration)).build());
        }
    }
}

