/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThresholdUnit {
    COUNT("COUNT"),
    PERCENTAGE("PERCENTAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThresholdUnit> VALUE_MAP;
    private final String value;

    private ThresholdUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThresholdUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThresholdUnit> knownValues() {
        EnumSet<ThresholdUnit> knownValues = EnumSet.allOf(ThresholdUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThresholdUnit.class, ThresholdUnit::toString);
    }
}

