/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperatorType {
    EQ("EQ"),
    REF_EQ("REF_EQ"),
    LE("LE"),
    GE("GE"),
    BETWEEN("BETWEEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperatorType> VALUE_MAP;
    private final String value;

    private OperatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperatorType> knownValues() {
        EnumSet<OperatorType> knownValues = EnumSet.allOf(OperatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperatorType.class, OperatorType::toString);
    }
}

