/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceInsightsMetricDimensionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceInsightsMetricDimensionGroup> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(PerformanceInsightsMetricDimensionGroup.getter(PerformanceInsightsMetricDimensionGroup::group)).setter(PerformanceInsightsMetricDimensionGroup.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(PerformanceInsightsMetricDimensionGroup.getter(PerformanceInsightsMetricDimensionGroup::dimensions)).setter(PerformanceInsightsMetricDimensionGroup.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(PerformanceInsightsMetricDimensionGroup.getter(PerformanceInsightsMetricDimensionGroup::limit)).setter(PerformanceInsightsMetricDimensionGroup.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, DIMENSIONS_FIELD, LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String group;
    private final List<String> dimensions;
    private final Integer limit;

    private PerformanceInsightsMetricDimensionGroup(BuilderImpl builder) {
        this.group = builder.group;
        this.dimensions = builder.dimensions;
        this.limit = builder.limit;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<String> dimensions() {
        return this.dimensions;
    }

    public final Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetricDimensionGroup)) {
            return false;
        }
        PerformanceInsightsMetricDimensionGroup other = (PerformanceInsightsMetricDimensionGroup)obj;
        return Objects.equals(this.group(), other.group()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceInsightsMetricDimensionGroup").add("Group", (Object)this.group()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsMetricDimensionGroup, T> g) {
        return obj -> g.apply((PerformanceInsightsMetricDimensionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private List<String> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsMetricDimensionGroup model) {
            this.group(model.group);
            this.dimensions(model.dimensions);
            this.limit(model.limit);
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        @Transient
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final Collection<String> getDimensions() {
            if (this.dimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensions;
        }

        public final void setDimensions(Collection<String> dimensions) {
            this.dimensions = PerformanceInsightsMetricDimensionsCopier.copy(dimensions);
        }

        @Override
        @Transient
        public final Builder dimensions(Collection<String> dimensions) {
            this.dimensions = PerformanceInsightsMetricDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensions(String ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PerformanceInsightsMetricDimensionGroup build() {
            return new PerformanceInsightsMetricDimensionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceInsightsMetricDimensionGroup> {
        public Builder group(String var1);

        public Builder dimensions(Collection<String> var1);

        public Builder dimensions(String ... var1);

        public Builder limit(Integer var1);
    }
}

