/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.services.directory.model.ReplicationScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionalForwarder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionalForwarder> {
    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteDomainName").getter(ConditionalForwarder.getter(ConditionalForwarder::remoteDomainName)).setter(ConditionalForwarder.setter(Builder::remoteDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()}).build();
    private static final SdkField<List<String>> DNS_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIpAddrs").getter(ConditionalForwarder.getter(ConditionalForwarder::dnsIpAddrs)).setter(ConditionalForwarder.setter(Builder::dnsIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationScope").getter(ConditionalForwarder.getter(ConditionalForwarder::replicationScopeAsString)).setter(ConditionalForwarder.setter(Builder::replicationScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_DOMAIN_NAME_FIELD, DNS_IP_ADDRS_FIELD, REPLICATION_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String remoteDomainName;
    private final List<String> dnsIpAddrs;
    private final String replicationScope;

    private ConditionalForwarder(BuilderImpl builder) {
        this.remoteDomainName = builder.remoteDomainName;
        this.dnsIpAddrs = builder.dnsIpAddrs;
        this.replicationScope = builder.replicationScope;
    }

    public final String remoteDomainName() {
        return this.remoteDomainName;
    }

    public final boolean hasDnsIpAddrs() {
        return this.dnsIpAddrs != null && !(this.dnsIpAddrs instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIpAddrs() {
        return this.dnsIpAddrs;
    }

    public final ReplicationScope replicationScope() {
        return ReplicationScope.fromValue(this.replicationScope);
    }

    public final String replicationScopeAsString() {
        return this.replicationScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalForwarder)) {
            return false;
        }
        ConditionalForwarder other = (ConditionalForwarder)obj;
        return Objects.equals(this.remoteDomainName(), other.remoteDomainName()) && this.hasDnsIpAddrs() == other.hasDnsIpAddrs() && Objects.equals(this.dnsIpAddrs(), other.dnsIpAddrs()) && Objects.equals(this.replicationScopeAsString(), other.replicationScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionalForwarder").add("RemoteDomainName", (Object)this.remoteDomainName()).add("DnsIpAddrs", this.hasDnsIpAddrs() ? this.dnsIpAddrs() : null).add("ReplicationScope", (Object)this.replicationScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemoteDomainName": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainName()));
            }
            case "DnsIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.dnsIpAddrs()));
            }
            case "ReplicationScope": {
                return Optional.ofNullable(clazz.cast(this.replicationScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalForwarder, T> g) {
        return obj -> g.apply((ConditionalForwarder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String remoteDomainName;
        private List<String> dnsIpAddrs = DefaultSdkAutoConstructList.getInstance();
        private String replicationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalForwarder model) {
            this.remoteDomainName(model.remoteDomainName);
            this.dnsIpAddrs(model.dnsIpAddrs);
            this.replicationScope(model.replicationScope);
        }

        public final String getRemoteDomainName() {
            return this.remoteDomainName;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        @Override
        @Transient
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final Collection<String> getDnsIpAddrs() {
            if (this.dnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIpAddrs;
        }

        public final void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
        }

        @Override
        @Transient
        public final Builder dnsIpAddrs(Collection<String> dnsIpAddrs) {
            this.dnsIpAddrs = DnsIpAddrsCopier.copy(dnsIpAddrs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dnsIpAddrs(String ... dnsIpAddrs) {
            this.dnsIpAddrs(Arrays.asList(dnsIpAddrs));
            return this;
        }

        public final String getReplicationScope() {
            return this.replicationScope;
        }

        public final void setReplicationScope(String replicationScope) {
            this.replicationScope = replicationScope;
        }

        @Override
        @Transient
        public final Builder replicationScope(String replicationScope) {
            this.replicationScope = replicationScope;
            return this;
        }

        @Override
        @Transient
        public final Builder replicationScope(ReplicationScope replicationScope) {
            this.replicationScope(replicationScope == null ? null : replicationScope.toString());
            return this;
        }

        public ConditionalForwarder build() {
            return new ConditionalForwarder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionalForwarder> {
        public Builder remoteDomainName(String var1);

        public Builder dnsIpAddrs(Collection<String> var1);

        public Builder dnsIpAddrs(String ... var1);

        public Builder replicationScope(String var1);

        public Builder replicationScope(ReplicationScope var1);
    }
}

