/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.EventPredictionSummary;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ListOfEventPredictionSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventPredictionsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, ListEventPredictionsResponse> {
    private static final SdkField<List<EventPredictionSummary>> EVENT_PREDICTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventPredictionSummaries").getter(ListEventPredictionsResponse.getter(ListEventPredictionsResponse::eventPredictionSummaries)).setter(ListEventPredictionsResponse.setter(Builder::eventPredictionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPredictionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventPredictionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEventPredictionsResponse.getter(ListEventPredictionsResponse::nextToken)).setter(ListEventPredictionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_PREDICTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<EventPredictionSummary> eventPredictionSummaries;
    private final String nextToken;

    private ListEventPredictionsResponse(BuilderImpl builder) {
        super(builder);
        this.eventPredictionSummaries = builder.eventPredictionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventPredictionSummaries() {
        return this.eventPredictionSummaries != null && !(this.eventPredictionSummaries instanceof SdkAutoConstructList);
    }

    public final List<EventPredictionSummary> eventPredictionSummaries() {
        return this.eventPredictionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventPredictionSummaries() ? this.eventPredictionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventPredictionsResponse)) {
            return false;
        }
        ListEventPredictionsResponse other = (ListEventPredictionsResponse)((Object)obj);
        return this.hasEventPredictionSummaries() == other.hasEventPredictionSummaries() && Objects.equals(this.eventPredictionSummaries(), other.eventPredictionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventPredictionsResponse").add("EventPredictionSummaries", this.hasEventPredictionSummaries() ? this.eventPredictionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventPredictionSummaries": {
                return Optional.ofNullable(clazz.cast(this.eventPredictionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventPredictionsResponse, T> g) {
        return obj -> g.apply((ListEventPredictionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<EventPredictionSummary> eventPredictionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventPredictionsResponse model) {
            super(model);
            this.eventPredictionSummaries(model.eventPredictionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<EventPredictionSummary.Builder> getEventPredictionSummaries() {
            List<EventPredictionSummary.Builder> result = ListOfEventPredictionSummariesCopier.copyToBuilder(this.eventPredictionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventPredictionSummaries(Collection<EventPredictionSummary.BuilderImpl> eventPredictionSummaries) {
            this.eventPredictionSummaries = ListOfEventPredictionSummariesCopier.copyFromBuilder(eventPredictionSummaries);
        }

        @Override
        @Transient
        public final Builder eventPredictionSummaries(Collection<EventPredictionSummary> eventPredictionSummaries) {
            this.eventPredictionSummaries = ListOfEventPredictionSummariesCopier.copy(eventPredictionSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventPredictionSummaries(EventPredictionSummary ... eventPredictionSummaries) {
            this.eventPredictionSummaries(Arrays.asList(eventPredictionSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventPredictionSummaries(Consumer<EventPredictionSummary.Builder> ... eventPredictionSummaries) {
            this.eventPredictionSummaries(Stream.of(eventPredictionSummaries).map(c -> (EventPredictionSummary)((EventPredictionSummary.Builder)EventPredictionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventPredictionsResponse build() {
            return new ListEventPredictionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventPredictionsResponse> {
        public Builder eventPredictionSummaries(Collection<EventPredictionSummary> var1);

        public Builder eventPredictionSummaries(EventPredictionSummary ... var1);

        public Builder eventPredictionSummaries(Consumer<EventPredictionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

