/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ExternalEventsDetail;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.IngestedEventsDetail;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.services.frauddetector.model.Tag;
import software.amazon.awssdk.services.frauddetector.model._tagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelVersionRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, UpdateModelVersionRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(UpdateModelVersionRequest.getter(UpdateModelVersionRequest::modelId)).setter(UpdateModelVersionRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelType").getter(UpdateModelVersionRequest.getter(UpdateModelVersionRequest::modelTypeAsString)).setter(UpdateModelVersionRequest.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> MAJOR_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersionNumber").getter(UpdateModelVersionRequest.getter(UpdateModelVersionRequest::majorVersionNumber)).setter(UpdateModelVersionRequest.setter(Builder::majorVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersionNumber").build()}).build();
    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalEventsDetail").getter(UpdateModelVersionRequest.getter(UpdateModelVersionRequest::externalEventsDetail)).setter(UpdateModelVersionRequest.setter(Builder::externalEventsDetail)).constructor(ExternalEventsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build()}).build();
    private static final SdkField<IngestedEventsDetail> INGESTED_EVENTS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ingestedEventsDetail").getter(UpdateModelVersionRequest.getter(UpdateModelVersionRequest::ingestedEventsDetail)).setter(UpdateModelVersionRequest.setter(Builder::ingestedEventsDetail)).constructor(IngestedEventsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestedEventsDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(UpdateModelVersionRequest.getter(UpdateModelVersionRequest::tags)).setter(UpdateModelVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, MAJOR_VERSION_NUMBER_FIELD, EXTERNAL_EVENTS_DETAIL_FIELD, INGESTED_EVENTS_DETAIL_FIELD, TAGS_FIELD));
    private final String modelId;
    private final String modelType;
    private final String majorVersionNumber;
    private final ExternalEventsDetail externalEventsDetail;
    private final IngestedEventsDetail ingestedEventsDetail;
    private final List<Tag> tags;

    private UpdateModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.majorVersionNumber = builder.majorVersionNumber;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.ingestedEventsDetail = builder.ingestedEventsDetail;
        this.tags = builder.tags;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public final String modelTypeAsString() {
        return this.modelType;
    }

    public final String majorVersionNumber() {
        return this.majorVersionNumber;
    }

    public final ExternalEventsDetail externalEventsDetail() {
        return this.externalEventsDetail;
    }

    public final IngestedEventsDetail ingestedEventsDetail() {
        return this.ingestedEventsDetail;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestedEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelVersionRequest)) {
            return false;
        }
        UpdateModelVersionRequest other = (UpdateModelVersionRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.majorVersionNumber(), other.majorVersionNumber()) && Objects.equals(this.externalEventsDetail(), other.externalEventsDetail()) && Objects.equals(this.ingestedEventsDetail(), other.ingestedEventsDetail()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelVersionRequest").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("MajorVersionNumber", (Object)this.majorVersionNumber()).add("ExternalEventsDetail", (Object)this.externalEventsDetail()).add("IngestedEventsDetail", (Object)this.ingestedEventsDetail()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "majorVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.majorVersionNumber()));
            }
            case "externalEventsDetail": {
                return Optional.ofNullable(clazz.cast(this.externalEventsDetail()));
            }
            case "ingestedEventsDetail": {
                return Optional.ofNullable(clazz.cast(this.ingestedEventsDetail()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelVersionRequest, T> g) {
        return obj -> g.apply((UpdateModelVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String majorVersionNumber;
        private ExternalEventsDetail externalEventsDetail;
        private IngestedEventsDetail ingestedEventsDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelVersionRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.majorVersionNumber(model.majorVersionNumber);
            this.externalEventsDetail(model.externalEventsDetail);
            this.ingestedEventsDetail(model.ingestedEventsDetail);
            this.tags(model.tags);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        @Transient
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        @Transient
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        @Transient
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getMajorVersionNumber() {
            return this.majorVersionNumber;
        }

        public final void setMajorVersionNumber(String majorVersionNumber) {
            this.majorVersionNumber = majorVersionNumber;
        }

        @Override
        @Transient
        public final Builder majorVersionNumber(String majorVersionNumber) {
            this.majorVersionNumber = majorVersionNumber;
            return this;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return this.externalEventsDetail != null ? this.externalEventsDetail.toBuilder() : null;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        @Override
        @Transient
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final IngestedEventsDetail.Builder getIngestedEventsDetail() {
            return this.ingestedEventsDetail != null ? this.ingestedEventsDetail.toBuilder() : null;
        }

        public final void setIngestedEventsDetail(IngestedEventsDetail.BuilderImpl ingestedEventsDetail) {
            this.ingestedEventsDetail = ingestedEventsDetail != null ? ingestedEventsDetail.build() : null;
        }

        @Override
        @Transient
        public final Builder ingestedEventsDetail(IngestedEventsDetail ingestedEventsDetail) {
            this.ingestedEventsDetail = ingestedEventsDetail;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelVersionRequest build() {
            return new UpdateModelVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelVersionRequest> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder majorVersionNumber(String var1);

        public Builder externalEventsDetail(ExternalEventsDetail var1);

        default public Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return this.externalEventsDetail((ExternalEventsDetail)((ExternalEventsDetail.Builder)ExternalEventsDetail.builder().applyMutation(externalEventsDetail)).build());
        }

        public Builder ingestedEventsDetail(IngestedEventsDetail var1);

        default public Builder ingestedEventsDetail(Consumer<IngestedEventsDetail.Builder> ingestedEventsDetail) {
            return this.ingestedEventsDetail((IngestedEventsDetail)((IngestedEventsDetail.Builder)IngestedEventsDetail.builder().applyMutation(ingestedEventsDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

