/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataRepositoryAssociationRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, CreateDataRepositoryAssociationRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::fileSystemId)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemPath").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::fileSystemPath)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::fileSystemPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemPath").build()}).build();
    private static final SdkField<String> DATA_REPOSITORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataRepositoryPath").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::dataRepositoryPath)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::dataRepositoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryPath").build()}).build();
    private static final SdkField<Boolean> BATCH_IMPORT_META_DATA_ON_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BatchImportMetaDataOnCreate").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::batchImportMetaDataOnCreate)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::batchImportMetaDataOnCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchImportMetaDataOnCreate").build()}).build();
    private static final SdkField<Integer> IMPORTED_FILE_CHUNK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ImportedFileChunkSize").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::importedFileChunkSize)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::importedFileChunkSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedFileChunkSize").build()}).build();
    private static final SdkField<S3DataRepositoryConfiguration> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::s3)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::s3)).constructor(S3DataRepositoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::clientRequestToken)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDataRepositoryAssociationRequest.getter(CreateDataRepositoryAssociationRequest::tags)).setter(CreateDataRepositoryAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_PATH_FIELD, DATA_REPOSITORY_PATH_FIELD, BATCH_IMPORT_META_DATA_ON_CREATE_FIELD, IMPORTED_FILE_CHUNK_SIZE_FIELD, S3_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final String fileSystemId;
    private final String fileSystemPath;
    private final String dataRepositoryPath;
    private final Boolean batchImportMetaDataOnCreate;
    private final Integer importedFileChunkSize;
    private final S3DataRepositoryConfiguration s3;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateDataRepositoryAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemPath = builder.fileSystemPath;
        this.dataRepositoryPath = builder.dataRepositoryPath;
        this.batchImportMetaDataOnCreate = builder.batchImportMetaDataOnCreate;
        this.importedFileChunkSize = builder.importedFileChunkSize;
        this.s3 = builder.s3;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String fileSystemPath() {
        return this.fileSystemPath;
    }

    public final String dataRepositoryPath() {
        return this.dataRepositoryPath;
    }

    public final Boolean batchImportMetaDataOnCreate() {
        return this.batchImportMetaDataOnCreate;
    }

    public final Integer importedFileChunkSize() {
        return this.importedFileChunkSize;
    }

    public final S3DataRepositoryConfiguration s3() {
        return this.s3;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRepositoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchImportMetaDataOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedFileChunkSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataRepositoryAssociationRequest)) {
            return false;
        }
        CreateDataRepositoryAssociationRequest other = (CreateDataRepositoryAssociationRequest)((Object)obj);
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.fileSystemPath(), other.fileSystemPath()) && Objects.equals(this.dataRepositoryPath(), other.dataRepositoryPath()) && Objects.equals(this.batchImportMetaDataOnCreate(), other.batchImportMetaDataOnCreate()) && Objects.equals(this.importedFileChunkSize(), other.importedFileChunkSize()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataRepositoryAssociationRequest").add("FileSystemId", (Object)this.fileSystemId()).add("FileSystemPath", (Object)this.fileSystemPath()).add("DataRepositoryPath", (Object)this.dataRepositoryPath()).add("BatchImportMetaDataOnCreate", (Object)this.batchImportMetaDataOnCreate()).add("ImportedFileChunkSize", (Object)this.importedFileChunkSize()).add("S3", (Object)this.s3()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "FileSystemPath": {
                return Optional.ofNullable(clazz.cast(this.fileSystemPath()));
            }
            case "DataRepositoryPath": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryPath()));
            }
            case "BatchImportMetaDataOnCreate": {
                return Optional.ofNullable(clazz.cast(this.batchImportMetaDataOnCreate()));
            }
            case "ImportedFileChunkSize": {
                return Optional.ofNullable(clazz.cast(this.importedFileChunkSize()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataRepositoryAssociationRequest, T> g) {
        return obj -> g.apply((CreateDataRepositoryAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String fileSystemPath;
        private String dataRepositoryPath;
        private Boolean batchImportMetaDataOnCreate;
        private Integer importedFileChunkSize;
        private S3DataRepositoryConfiguration s3;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataRepositoryAssociationRequest model) {
            super(model);
            this.fileSystemId(model.fileSystemId);
            this.fileSystemPath(model.fileSystemPath);
            this.dataRepositoryPath(model.dataRepositoryPath);
            this.batchImportMetaDataOnCreate(model.batchImportMetaDataOnCreate);
            this.importedFileChunkSize(model.importedFileChunkSize);
            this.s3(model.s3);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemPath() {
            return this.fileSystemPath;
        }

        public final void setFileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
        }

        @Override
        @Transient
        public final Builder fileSystemPath(String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
            return this;
        }

        public final String getDataRepositoryPath() {
            return this.dataRepositoryPath;
        }

        public final void setDataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
        }

        @Override
        @Transient
        public final Builder dataRepositoryPath(String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
            return this;
        }

        public final Boolean getBatchImportMetaDataOnCreate() {
            return this.batchImportMetaDataOnCreate;
        }

        public final void setBatchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
        }

        @Override
        @Transient
        public final Builder batchImportMetaDataOnCreate(Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
            return this;
        }

        public final Integer getImportedFileChunkSize() {
            return this.importedFileChunkSize;
        }

        public final void setImportedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
        }

        @Override
        @Transient
        public final Builder importedFileChunkSize(Integer importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        public final S3DataRepositoryConfiguration.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3DataRepositoryConfiguration.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        @Transient
        public final Builder s3(S3DataRepositoryConfiguration s3) {
            this.s3 = s3;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataRepositoryAssociationRequest build() {
            return new CreateDataRepositoryAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataRepositoryAssociationRequest> {
        public Builder fileSystemId(String var1);

        public Builder fileSystemPath(String var1);

        public Builder dataRepositoryPath(String var1);

        public Builder batchImportMetaDataOnCreate(Boolean var1);

        public Builder importedFileChunkSize(Integer var1);

        public Builder s3(S3DataRepositoryConfiguration var1);

        default public Builder s3(Consumer<S3DataRepositoryConfiguration.Builder> s3) {
            return this.s3((S3DataRepositoryConfiguration)((S3DataRepositoryConfiguration.Builder)S3DataRepositoryConfiguration.builder().applyMutation(s3)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

