/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroupsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomRoutingEndpointGroupsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListCustomRoutingEndpointGroupsResponse> {
    private static final SdkField<List<CustomRoutingEndpointGroup>> ENDPOINT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointGroups").getter(ListCustomRoutingEndpointGroupsResponse.getter(ListCustomRoutingEndpointGroupsResponse::endpointGroups)).setter(ListCustomRoutingEndpointGroupsResponse.setter(Builder::endpointGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingEndpointGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomRoutingEndpointGroupsResponse.getter(ListCustomRoutingEndpointGroupsResponse::nextToken)).setter(ListCustomRoutingEndpointGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CustomRoutingEndpointGroup> endpointGroups;
    private final String nextToken;

    private ListCustomRoutingEndpointGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointGroups = builder.endpointGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEndpointGroups() {
        return this.endpointGroups != null && !(this.endpointGroups instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingEndpointGroup> endpointGroups() {
        return this.endpointGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointGroups() ? this.endpointGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingEndpointGroupsResponse)) {
            return false;
        }
        ListCustomRoutingEndpointGroupsResponse other = (ListCustomRoutingEndpointGroupsResponse)((Object)obj);
        return this.hasEndpointGroups() == other.hasEndpointGroups() && Objects.equals(this.endpointGroups(), other.endpointGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomRoutingEndpointGroupsResponse").add("EndpointGroups", this.hasEndpointGroups() ? this.endpointGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointGroups": {
                return Optional.ofNullable(clazz.cast(this.endpointGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingEndpointGroupsResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingEndpointGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<CustomRoutingEndpointGroup> endpointGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingEndpointGroupsResponse model) {
            super(model);
            this.endpointGroups(model.endpointGroups);
            this.nextToken(model.nextToken);
        }

        public final List<CustomRoutingEndpointGroup.Builder> getEndpointGroups() {
            List<CustomRoutingEndpointGroup.Builder> result = CustomRoutingEndpointGroupsCopier.copyToBuilder(this.endpointGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointGroups(Collection<CustomRoutingEndpointGroup.BuilderImpl> endpointGroups) {
            this.endpointGroups = CustomRoutingEndpointGroupsCopier.copyFromBuilder(endpointGroups);
        }

        @Override
        @Transient
        public final Builder endpointGroups(Collection<CustomRoutingEndpointGroup> endpointGroups) {
            this.endpointGroups = CustomRoutingEndpointGroupsCopier.copy(endpointGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointGroups(CustomRoutingEndpointGroup ... endpointGroups) {
            this.endpointGroups(Arrays.asList(endpointGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointGroups(Consumer<CustomRoutingEndpointGroup.Builder> ... endpointGroups) {
            this.endpointGroups(Stream.of(endpointGroups).map(c -> (CustomRoutingEndpointGroup)((CustomRoutingEndpointGroup.Builder)CustomRoutingEndpointGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomRoutingEndpointGroupsResponse build() {
            return new ListCustomRoutingEndpointGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomRoutingEndpointGroupsResponse> {
        public Builder endpointGroups(Collection<CustomRoutingEndpointGroup> var1);

        public Builder endpointGroups(CustomRoutingEndpointGroup ... var1);

        public Builder endpointGroups(Consumer<CustomRoutingEndpointGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

