/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.AuthenticationSummary;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationType;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationsListCopier;
import software.amazon.awssdk.services.grafana.model.WorkspaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceSummary> {
    private static final SdkField<AuthenticationSummary> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authentication").getter(WorkspaceSummary.getter(WorkspaceSummary::authentication)).setter(WorkspaceSummary.setter(Builder::authentication)).constructor(AuthenticationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(WorkspaceSummary.getter(WorkspaceSummary::created)).setter(WorkspaceSummary.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkspaceSummary.getter(WorkspaceSummary::description)).setter(WorkspaceSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(WorkspaceSummary.getter(WorkspaceSummary::endpoint)).setter(WorkspaceSummary.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> GRAFANA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaVersion").getter(WorkspaceSummary.getter(WorkspaceSummary::grafanaVersion)).setter(WorkspaceSummary.setter(Builder::grafanaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersion").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(WorkspaceSummary.getter(WorkspaceSummary::id)).setter(WorkspaceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modified").getter(WorkspaceSummary.getter(WorkspaceSummary::modified)).setter(WorkspaceSummary.setter(Builder::modified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modified").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkspaceSummary.getter(WorkspaceSummary::name)).setter(WorkspaceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationDestinations").getter(WorkspaceSummary.getter(WorkspaceSummary::notificationDestinationsAsStrings)).setter(WorkspaceSummary.setter(Builder::notificationDestinationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkspaceSummary.getter(WorkspaceSummary::statusAsString)).setter(WorkspaceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD, CREATED_FIELD, DESCRIPTION_FIELD, ENDPOINT_FIELD, GRAFANA_VERSION_FIELD, ID_FIELD, MODIFIED_FIELD, NAME_FIELD, NOTIFICATION_DESTINATIONS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AuthenticationSummary authentication;
    private final Instant created;
    private final String description;
    private final String endpoint;
    private final String grafanaVersion;
    private final String id;
    private final Instant modified;
    private final String name;
    private final List<String> notificationDestinations;
    private final String status;

    private WorkspaceSummary(BuilderImpl builder) {
        this.authentication = builder.authentication;
        this.created = builder.created;
        this.description = builder.description;
        this.endpoint = builder.endpoint;
        this.grafanaVersion = builder.grafanaVersion;
        this.id = builder.id;
        this.modified = builder.modified;
        this.name = builder.name;
        this.notificationDestinations = builder.notificationDestinations;
        this.status = builder.status;
    }

    public final AuthenticationSummary authentication() {
        return this.authentication;
    }

    public final Instant created() {
        return this.created;
    }

    public final String description() {
        return this.description;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String grafanaVersion() {
        return this.grafanaVersion;
    }

    public final String id() {
        return this.id;
    }

    public final Instant modified() {
        return this.modified;
    }

    public final String name() {
        return this.name;
    }

    public final List<NotificationDestinationType> notificationDestinations() {
        return NotificationDestinationsListCopier.copyStringToEnum(this.notificationDestinations);
    }

    public final boolean hasNotificationDestinations() {
        return this.notificationDestinations != null && !(this.notificationDestinations instanceof SdkAutoConstructList);
    }

    public final List<String> notificationDestinationsAsStrings() {
        return this.notificationDestinations;
    }

    public final WorkspaceStatus status() {
        return WorkspaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.modified());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationDestinations() ? this.notificationDestinationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceSummary)) {
            return false;
        }
        WorkspaceSummary other = (WorkspaceSummary)obj;
        return Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.grafanaVersion(), other.grafanaVersion()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.modified(), other.modified()) && Objects.equals(this.name(), other.name()) && this.hasNotificationDestinations() == other.hasNotificationDestinations() && Objects.equals(this.notificationDestinationsAsStrings(), other.notificationDestinationsAsStrings()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceSummary").add("Authentication", (Object)this.authentication()).add("Created", (Object)this.created()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Endpoint", (Object)this.endpoint()).add("GrafanaVersion", (Object)this.grafanaVersion()).add("Id", (Object)this.id()).add("Modified", (Object)this.modified()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("NotificationDestinations", this.hasNotificationDestinations() ? this.notificationDestinationsAsStrings() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "grafanaVersion": {
                return Optional.ofNullable(clazz.cast(this.grafanaVersion()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "modified": {
                return Optional.ofNullable(clazz.cast(this.modified()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "notificationDestinations": {
                return Optional.ofNullable(clazz.cast(this.notificationDestinationsAsStrings()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceSummary, T> g) {
        return obj -> g.apply((WorkspaceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AuthenticationSummary authentication;
        private Instant created;
        private String description;
        private String endpoint;
        private String grafanaVersion;
        private String id;
        private Instant modified;
        private String name;
        private List<String> notificationDestinations = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceSummary model) {
            this.authentication(model.authentication);
            this.created(model.created);
            this.description(model.description);
            this.endpoint(model.endpoint);
            this.grafanaVersion(model.grafanaVersion);
            this.id(model.id);
            this.modified(model.modified);
            this.name(model.name);
            this.notificationDestinationsWithStrings(model.notificationDestinations);
            this.status(model.status);
        }

        public final AuthenticationSummary.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(AuthenticationSummary.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        @Transient
        public final Builder authentication(AuthenticationSummary authentication) {
            this.authentication = authentication;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getGrafanaVersion() {
            return this.grafanaVersion;
        }

        public final void setGrafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
        }

        @Override
        @Transient
        public final Builder grafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModified() {
            return this.modified;
        }

        public final void setModified(Instant modified) {
            this.modified = modified;
        }

        @Override
        @Transient
        public final Builder modified(Instant modified) {
            this.modified = modified;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNotificationDestinations() {
            if (this.notificationDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationDestinations;
        }

        public final void setNotificationDestinations(Collection<String> notificationDestinations) {
            this.notificationDestinations = NotificationDestinationsListCopier.copy(notificationDestinations);
        }

        @Override
        @Transient
        public final Builder notificationDestinationsWithStrings(Collection<String> notificationDestinations) {
            this.notificationDestinations = NotificationDestinationsListCopier.copy(notificationDestinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationDestinationsWithStrings(String ... notificationDestinations) {
            this.notificationDestinationsWithStrings(Arrays.asList(notificationDestinations));
            return this;
        }

        @Override
        @Transient
        public final Builder notificationDestinations(Collection<NotificationDestinationType> notificationDestinations) {
            this.notificationDestinations = NotificationDestinationsListCopier.copyEnumToString(notificationDestinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationDestinations(NotificationDestinationType ... notificationDestinations) {
            this.notificationDestinations(Arrays.asList(notificationDestinations));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(WorkspaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public WorkspaceSummary build() {
            return new WorkspaceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceSummary> {
        public Builder authentication(AuthenticationSummary var1);

        default public Builder authentication(Consumer<AuthenticationSummary.Builder> authentication) {
            return this.authentication((AuthenticationSummary)((AuthenticationSummary.Builder)AuthenticationSummary.builder().applyMutation(authentication)).build());
        }

        public Builder created(Instant var1);

        public Builder description(String var1);

        public Builder endpoint(String var1);

        public Builder grafanaVersion(String var1);

        public Builder id(String var1);

        public Builder modified(Instant var1);

        public Builder name(String var1);

        public Builder notificationDestinationsWithStrings(Collection<String> var1);

        public Builder notificationDestinationsWithStrings(String ... var1);

        public Builder notificationDestinations(Collection<NotificationDestinationType> var1);

        public Builder notificationDestinations(NotificationDestinationType ... var1);

        public Builder status(String var1);

        public Builder status(WorkspaceStatus var1);
    }
}

