/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactStatus {
    AVAILABLE("AVAILABLE"),
    AWS_CANCELLED("AWS_CANCELLED"),
    AWS_FAILED("AWS_FAILED"),
    CANCELLED("CANCELLED"),
    CANCELLING("CANCELLING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    FAILED_TO_SCHEDULE("FAILED_TO_SCHEDULE"),
    PASS("PASS"),
    POSTPASS("POSTPASS"),
    PREPASS("PREPASS"),
    SCHEDULED("SCHEDULED"),
    SCHEDULING("SCHEDULING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactStatus> VALUE_MAP;
    private final String value;

    private ContactStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactStatus> knownValues() {
        EnumSet<ContactStatus> knownValues = EnumSet.allOf(ContactStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactStatus.class, ContactStatus::toString);
    }
}

