/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeThingResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeThingResponse> {
    private static final SdkField<String> DEFAULT_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultClientId").getter(DescribeThingResponse.getter(DescribeThingResponse::defaultClientId)).setter(DescribeThingResponse.setter(Builder::defaultClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultClientId").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(DescribeThingResponse.getter(DescribeThingResponse::thingName)).setter(DescribeThingResponse.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingId").getter(DescribeThingResponse.getter(DescribeThingResponse::thingId)).setter(DescribeThingResponse.setter(Builder::thingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingId").build()}).build();
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingArn").getter(DescribeThingResponse.getter(DescribeThingResponse::thingArn)).setter(DescribeThingResponse.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()}).build();
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingTypeName").getter(DescribeThingResponse.getter(DescribeThingResponse::thingTypeName)).setter(DescribeThingResponse.setter(Builder::thingTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(DescribeThingResponse.getter(DescribeThingResponse::attributes)).setter(DescribeThingResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("version").getter(DescribeThingResponse.getter(DescribeThingResponse::version)).setter(DescribeThingResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupName").getter(DescribeThingResponse.getter(DescribeThingResponse::billingGroupName)).setter(DescribeThingResponse.setter(Builder::billingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_CLIENT_ID_FIELD, THING_NAME_FIELD, THING_ID_FIELD, THING_ARN_FIELD, THING_TYPE_NAME_FIELD, ATTRIBUTES_FIELD, VERSION_FIELD, BILLING_GROUP_NAME_FIELD));
    private final String defaultClientId;
    private final String thingName;
    private final String thingId;
    private final String thingArn;
    private final String thingTypeName;
    private final Map<String, String> attributes;
    private final Long version;
    private final String billingGroupName;

    private DescribeThingResponse(BuilderImpl builder) {
        super(builder);
        this.defaultClientId = builder.defaultClientId;
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingArn = builder.thingArn;
        this.thingTypeName = builder.thingTypeName;
        this.attributes = builder.attributes;
        this.version = builder.version;
        this.billingGroupName = builder.billingGroupName;
    }

    public final String defaultClientId() {
        return this.defaultClientId;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final String thingId() {
        return this.thingId;
    }

    public final String thingArn() {
        return this.thingArn;
    }

    public final String thingTypeName() {
        return this.thingTypeName;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final Long version() {
        return this.version;
    }

    public final String billingGroupName() {
        return this.billingGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingResponse)) {
            return false;
        }
        DescribeThingResponse other = (DescribeThingResponse)((Object)obj);
        return Objects.equals(this.defaultClientId(), other.defaultClientId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingId(), other.thingId()) && Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.billingGroupName(), other.billingGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeThingResponse").add("DefaultClientId", (Object)this.defaultClientId()).add("ThingName", (Object)this.thingName()).add("ThingId", (Object)this.thingId()).add("ThingArn", (Object)this.thingArn()).add("ThingTypeName", (Object)this.thingTypeName()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Version", (Object)this.version()).add("BillingGroupName", (Object)this.billingGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultClientId": {
                return Optional.ofNullable(clazz.cast(this.defaultClientId()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingId": {
                return Optional.ofNullable(clazz.cast(this.thingId()));
            }
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "billingGroupName": {
                return Optional.ofNullable(clazz.cast(this.billingGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThingResponse, T> g) {
        return obj -> g.apply((DescribeThingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String defaultClientId;
        private String thingName;
        private String thingId;
        private String thingArn;
        private String thingTypeName;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Long version;
        private String billingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingResponse model) {
            super(model);
            this.defaultClientId(model.defaultClientId);
            this.thingName(model.thingName);
            this.thingId(model.thingId);
            this.thingArn(model.thingArn);
            this.thingTypeName(model.thingTypeName);
            this.attributes(model.attributes);
            this.version(model.version);
            this.billingGroupName(model.billingGroupName);
        }

        public final String getDefaultClientId() {
            return this.defaultClientId;
        }

        public final void setDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        @Override
        @Transient
        public final Builder defaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingId() {
            return this.thingId;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        @Override
        @Transient
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        @Transient
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        @Transient
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getBillingGroupName() {
            return this.billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        @Transient
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        @Override
        public DescribeThingResponse build() {
            return new DescribeThingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeThingResponse> {
        public Builder defaultClientId(String var1);

        public Builder thingName(String var1);

        public Builder thingId(String var1);

        public Builder thingArn(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder version(Long var1);

        public Builder billingGroupName(String var1);
    }
}

