/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse;

public class ListAuditMitigationActionsExecutionsPublisher
implements SdkPublisher<ListAuditMitigationActionsExecutionsResponse> {
    private final IotAsyncClient client;
    private final ListAuditMitigationActionsExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuditMitigationActionsExecutionsPublisher(IotAsyncClient client, ListAuditMitigationActionsExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuditMitigationActionsExecutionsPublisher(IotAsyncClient client, ListAuditMitigationActionsExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuditMitigationActionsExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuditMitigationActionsExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuditMitigationActionExecutionMetadata> actionsExecutions() {
        Function<ListAuditMitigationActionsExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionsExecutions() != null) {
                return response.actionsExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuditMitigationActionsExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuditMitigationActionsExecutionsResponseFetcher
    implements AsyncPageFetcher<ListAuditMitigationActionsExecutionsResponse> {
        private ListAuditMitigationActionsExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditMitigationActionsExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAuditMitigationActionsExecutionsResponse> nextPage(ListAuditMitigationActionsExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListAuditMitigationActionsExecutionsPublisher.this.client.listAuditMitigationActionsExecutions(ListAuditMitigationActionsExecutionsPublisher.this.firstRequest);
            }
            return ListAuditMitigationActionsExecutionsPublisher.this.client.listAuditMitigationActionsExecutions((ListAuditMitigationActionsExecutionsRequest)((Object)ListAuditMitigationActionsExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

