/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreSummariesCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreSummary;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatastoresResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, ListDatastoresResponse> {
    private static final SdkField<List<DatastoreSummary>> DATASTORE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datastoreSummaries").getter(ListDatastoresResponse.getter(ListDatastoresResponse::datastoreSummaries)).setter(ListDatastoresResponse.setter(Builder::datastoreSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatastoreSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDatastoresResponse.getter(ListDatastoresResponse::nextToken)).setter(ListDatastoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatastoreSummary> datastoreSummaries;
    private final String nextToken;

    private ListDatastoresResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreSummaries = builder.datastoreSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatastoreSummaries() {
        return this.datastoreSummaries != null && !(this.datastoreSummaries instanceof SdkAutoConstructList);
    }

    public final List<DatastoreSummary> datastoreSummaries() {
        return this.datastoreSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatastoreSummaries() ? this.datastoreSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatastoresResponse)) {
            return false;
        }
        ListDatastoresResponse other = (ListDatastoresResponse)((Object)obj);
        return this.hasDatastoreSummaries() == other.hasDatastoreSummaries() && Objects.equals(this.datastoreSummaries(), other.datastoreSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatastoresResponse").add("DatastoreSummaries", this.hasDatastoreSummaries() ? this.datastoreSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreSummaries": {
                return Optional.ofNullable(clazz.cast(this.datastoreSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatastoresResponse, T> g) {
        return obj -> g.apply((ListDatastoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<DatastoreSummary> datastoreSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatastoresResponse model) {
            super(model);
            this.datastoreSummaries(model.datastoreSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DatastoreSummary.Builder> getDatastoreSummaries() {
            List<DatastoreSummary.Builder> result = DatastoreSummariesCopier.copyToBuilder(this.datastoreSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatastoreSummaries(Collection<DatastoreSummary.BuilderImpl> datastoreSummaries) {
            this.datastoreSummaries = DatastoreSummariesCopier.copyFromBuilder(datastoreSummaries);
        }

        @Override
        @Transient
        public final Builder datastoreSummaries(Collection<DatastoreSummary> datastoreSummaries) {
            this.datastoreSummaries = DatastoreSummariesCopier.copy(datastoreSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datastoreSummaries(DatastoreSummary ... datastoreSummaries) {
            this.datastoreSummaries(Arrays.asList(datastoreSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datastoreSummaries(Consumer<DatastoreSummary.Builder> ... datastoreSummaries) {
            this.datastoreSummaries(Stream.of(datastoreSummaries).map(c -> (DatastoreSummary)((DatastoreSummary.Builder)DatastoreSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatastoresResponse build() {
            return new ListDatastoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatastoresResponse> {
        public Builder datastoreSummaries(Collection<DatastoreSummary> var1);

        public Builder datastoreSummaries(DatastoreSummary ... var1);

        public Builder datastoreSummaries(Consumer<DatastoreSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

