/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.AddAttributesActivity;
import software.amazon.awssdk.services.iotanalytics.model.ChannelActivity;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreActivity;
import software.amazon.awssdk.services.iotanalytics.model.DeviceRegistryEnrichActivity;
import software.amazon.awssdk.services.iotanalytics.model.DeviceShadowEnrichActivity;
import software.amazon.awssdk.services.iotanalytics.model.FilterActivity;
import software.amazon.awssdk.services.iotanalytics.model.LambdaActivity;
import software.amazon.awssdk.services.iotanalytics.model.MathActivity;
import software.amazon.awssdk.services.iotanalytics.model.RemoveAttributesActivity;
import software.amazon.awssdk.services.iotanalytics.model.SelectAttributesActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineActivity> {
    private static final SdkField<ChannelActivity> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channel").getter(PipelineActivity.getter(PipelineActivity::channel)).setter(PipelineActivity.setter(Builder::channel)).constructor(ChannelActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<LambdaActivity> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(PipelineActivity.getter(PipelineActivity::lambda)).setter(PipelineActivity.setter(Builder::lambda)).constructor(LambdaActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<DatastoreActivity> DATASTORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datastore").getter(PipelineActivity.getter(PipelineActivity::datastore)).setter(PipelineActivity.setter(Builder::datastore)).constructor(DatastoreActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastore").build()}).build();
    private static final SdkField<AddAttributesActivity> ADD_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("addAttributes").getter(PipelineActivity.getter(PipelineActivity::addAttributes)).setter(PipelineActivity.setter(Builder::addAttributes)).constructor(AddAttributesActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addAttributes").build()}).build();
    private static final SdkField<RemoveAttributesActivity> REMOVE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("removeAttributes").getter(PipelineActivity.getter(PipelineActivity::removeAttributes)).setter(PipelineActivity.setter(Builder::removeAttributes)).constructor(RemoveAttributesActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAttributes").build()}).build();
    private static final SdkField<SelectAttributesActivity> SELECT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("selectAttributes").getter(PipelineActivity.getter(PipelineActivity::selectAttributes)).setter(PipelineActivity.setter(Builder::selectAttributes)).constructor(SelectAttributesActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectAttributes").build()}).build();
    private static final SdkField<FilterActivity> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(PipelineActivity.getter(PipelineActivity::filter)).setter(PipelineActivity.setter(Builder::filter)).constructor(FilterActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<MathActivity> MATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("math").getter(PipelineActivity.getter(PipelineActivity::math)).setter(PipelineActivity.setter(Builder::math)).constructor(MathActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("math").build()}).build();
    private static final SdkField<DeviceRegistryEnrichActivity> DEVICE_REGISTRY_ENRICH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceRegistryEnrich").getter(PipelineActivity.getter(PipelineActivity::deviceRegistryEnrich)).setter(PipelineActivity.setter(Builder::deviceRegistryEnrich)).constructor(DeviceRegistryEnrichActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceRegistryEnrich").build()}).build();
    private static final SdkField<DeviceShadowEnrichActivity> DEVICE_SHADOW_ENRICH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceShadowEnrich").getter(PipelineActivity.getter(PipelineActivity::deviceShadowEnrich)).setter(PipelineActivity.setter(Builder::deviceShadowEnrich)).constructor(DeviceShadowEnrichActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceShadowEnrich").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, LAMBDA_FIELD, DATASTORE_FIELD, ADD_ATTRIBUTES_FIELD, REMOVE_ATTRIBUTES_FIELD, SELECT_ATTRIBUTES_FIELD, FILTER_FIELD, MATH_FIELD, DEVICE_REGISTRY_ENRICH_FIELD, DEVICE_SHADOW_ENRICH_FIELD));
    private static final long serialVersionUID = 1L;
    private final ChannelActivity channel;
    private final LambdaActivity lambda;
    private final DatastoreActivity datastore;
    private final AddAttributesActivity addAttributes;
    private final RemoveAttributesActivity removeAttributes;
    private final SelectAttributesActivity selectAttributes;
    private final FilterActivity filter;
    private final MathActivity math;
    private final DeviceRegistryEnrichActivity deviceRegistryEnrich;
    private final DeviceShadowEnrichActivity deviceShadowEnrich;

    private PipelineActivity(BuilderImpl builder) {
        this.channel = builder.channel;
        this.lambda = builder.lambda;
        this.datastore = builder.datastore;
        this.addAttributes = builder.addAttributes;
        this.removeAttributes = builder.removeAttributes;
        this.selectAttributes = builder.selectAttributes;
        this.filter = builder.filter;
        this.math = builder.math;
        this.deviceRegistryEnrich = builder.deviceRegistryEnrich;
        this.deviceShadowEnrich = builder.deviceShadowEnrich;
    }

    public final ChannelActivity channel() {
        return this.channel;
    }

    public final LambdaActivity lambda() {
        return this.lambda;
    }

    public final DatastoreActivity datastore() {
        return this.datastore;
    }

    public final AddAttributesActivity addAttributes() {
        return this.addAttributes;
    }

    public final RemoveAttributesActivity removeAttributes() {
        return this.removeAttributes;
    }

    public final SelectAttributesActivity selectAttributes() {
        return this.selectAttributes;
    }

    public final FilterActivity filter() {
        return this.filter;
    }

    public final MathActivity math() {
        return this.math;
    }

    public final DeviceRegistryEnrichActivity deviceRegistryEnrich() {
        return this.deviceRegistryEnrich;
    }

    public final DeviceShadowEnrichActivity deviceShadowEnrich() {
        return this.deviceShadowEnrich;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastore());
        hashCode = 31 * hashCode + Objects.hashCode(this.addAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.math());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRegistryEnrich());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceShadowEnrich());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineActivity)) {
            return false;
        }
        PipelineActivity other = (PipelineActivity)obj;
        return Objects.equals(this.channel(), other.channel()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.datastore(), other.datastore()) && Objects.equals(this.addAttributes(), other.addAttributes()) && Objects.equals(this.removeAttributes(), other.removeAttributes()) && Objects.equals(this.selectAttributes(), other.selectAttributes()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.math(), other.math()) && Objects.equals(this.deviceRegistryEnrich(), other.deviceRegistryEnrich()) && Objects.equals(this.deviceShadowEnrich(), other.deviceShadowEnrich());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineActivity").add("Channel", (Object)this.channel()).add("Lambda", (Object)this.lambda()).add("Datastore", (Object)this.datastore()).add("AddAttributes", (Object)this.addAttributes()).add("RemoveAttributes", (Object)this.removeAttributes()).add("SelectAttributes", (Object)this.selectAttributes()).add("Filter", (Object)this.filter()).add("Math", (Object)this.math()).add("DeviceRegistryEnrich", (Object)this.deviceRegistryEnrich()).add("DeviceShadowEnrich", (Object)this.deviceShadowEnrich()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "datastore": {
                return Optional.ofNullable(clazz.cast(this.datastore()));
            }
            case "addAttributes": {
                return Optional.ofNullable(clazz.cast(this.addAttributes()));
            }
            case "removeAttributes": {
                return Optional.ofNullable(clazz.cast(this.removeAttributes()));
            }
            case "selectAttributes": {
                return Optional.ofNullable(clazz.cast(this.selectAttributes()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "math": {
                return Optional.ofNullable(clazz.cast(this.math()));
            }
            case "deviceRegistryEnrich": {
                return Optional.ofNullable(clazz.cast(this.deviceRegistryEnrich()));
            }
            case "deviceShadowEnrich": {
                return Optional.ofNullable(clazz.cast(this.deviceShadowEnrich()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineActivity, T> g) {
        return obj -> g.apply((PipelineActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ChannelActivity channel;
        private LambdaActivity lambda;
        private DatastoreActivity datastore;
        private AddAttributesActivity addAttributes;
        private RemoveAttributesActivity removeAttributes;
        private SelectAttributesActivity selectAttributes;
        private FilterActivity filter;
        private MathActivity math;
        private DeviceRegistryEnrichActivity deviceRegistryEnrich;
        private DeviceShadowEnrichActivity deviceShadowEnrich;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineActivity model) {
            this.channel(model.channel);
            this.lambda(model.lambda);
            this.datastore(model.datastore);
            this.addAttributes(model.addAttributes);
            this.removeAttributes(model.removeAttributes);
            this.selectAttributes(model.selectAttributes);
            this.filter(model.filter);
            this.math(model.math);
            this.deviceRegistryEnrich(model.deviceRegistryEnrich);
            this.deviceShadowEnrich(model.deviceShadowEnrich);
        }

        public final ChannelActivity.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        public final void setChannel(ChannelActivity.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        @Transient
        public final Builder channel(ChannelActivity channel) {
            this.channel = channel;
            return this;
        }

        public final LambdaActivity.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaActivity.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        @Transient
        public final Builder lambda(LambdaActivity lambda) {
            this.lambda = lambda;
            return this;
        }

        public final DatastoreActivity.Builder getDatastore() {
            return this.datastore != null ? this.datastore.toBuilder() : null;
        }

        public final void setDatastore(DatastoreActivity.BuilderImpl datastore) {
            this.datastore = datastore != null ? datastore.build() : null;
        }

        @Override
        @Transient
        public final Builder datastore(DatastoreActivity datastore) {
            this.datastore = datastore;
            return this;
        }

        public final AddAttributesActivity.Builder getAddAttributes() {
            return this.addAttributes != null ? this.addAttributes.toBuilder() : null;
        }

        public final void setAddAttributes(AddAttributesActivity.BuilderImpl addAttributes) {
            this.addAttributes = addAttributes != null ? addAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder addAttributes(AddAttributesActivity addAttributes) {
            this.addAttributes = addAttributes;
            return this;
        }

        public final RemoveAttributesActivity.Builder getRemoveAttributes() {
            return this.removeAttributes != null ? this.removeAttributes.toBuilder() : null;
        }

        public final void setRemoveAttributes(RemoveAttributesActivity.BuilderImpl removeAttributes) {
            this.removeAttributes = removeAttributes != null ? removeAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder removeAttributes(RemoveAttributesActivity removeAttributes) {
            this.removeAttributes = removeAttributes;
            return this;
        }

        public final SelectAttributesActivity.Builder getSelectAttributes() {
            return this.selectAttributes != null ? this.selectAttributes.toBuilder() : null;
        }

        public final void setSelectAttributes(SelectAttributesActivity.BuilderImpl selectAttributes) {
            this.selectAttributes = selectAttributes != null ? selectAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder selectAttributes(SelectAttributesActivity selectAttributes) {
            this.selectAttributes = selectAttributes;
            return this;
        }

        public final FilterActivity.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(FilterActivity.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        @Transient
        public final Builder filter(FilterActivity filter) {
            this.filter = filter;
            return this;
        }

        public final MathActivity.Builder getMath() {
            return this.math != null ? this.math.toBuilder() : null;
        }

        public final void setMath(MathActivity.BuilderImpl math) {
            this.math = math != null ? math.build() : null;
        }

        @Override
        @Transient
        public final Builder math(MathActivity math) {
            this.math = math;
            return this;
        }

        public final DeviceRegistryEnrichActivity.Builder getDeviceRegistryEnrich() {
            return this.deviceRegistryEnrich != null ? this.deviceRegistryEnrich.toBuilder() : null;
        }

        public final void setDeviceRegistryEnrich(DeviceRegistryEnrichActivity.BuilderImpl deviceRegistryEnrich) {
            this.deviceRegistryEnrich = deviceRegistryEnrich != null ? deviceRegistryEnrich.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceRegistryEnrich(DeviceRegistryEnrichActivity deviceRegistryEnrich) {
            this.deviceRegistryEnrich = deviceRegistryEnrich;
            return this;
        }

        public final DeviceShadowEnrichActivity.Builder getDeviceShadowEnrich() {
            return this.deviceShadowEnrich != null ? this.deviceShadowEnrich.toBuilder() : null;
        }

        public final void setDeviceShadowEnrich(DeviceShadowEnrichActivity.BuilderImpl deviceShadowEnrich) {
            this.deviceShadowEnrich = deviceShadowEnrich != null ? deviceShadowEnrich.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceShadowEnrich(DeviceShadowEnrichActivity deviceShadowEnrich) {
            this.deviceShadowEnrich = deviceShadowEnrich;
            return this;
        }

        public PipelineActivity build() {
            return new PipelineActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineActivity> {
        public Builder channel(ChannelActivity var1);

        default public Builder channel(Consumer<ChannelActivity.Builder> channel) {
            return this.channel((ChannelActivity)((ChannelActivity.Builder)ChannelActivity.builder().applyMutation(channel)).build());
        }

        public Builder lambda(LambdaActivity var1);

        default public Builder lambda(Consumer<LambdaActivity.Builder> lambda) {
            return this.lambda((LambdaActivity)((LambdaActivity.Builder)LambdaActivity.builder().applyMutation(lambda)).build());
        }

        public Builder datastore(DatastoreActivity var1);

        default public Builder datastore(Consumer<DatastoreActivity.Builder> datastore) {
            return this.datastore((DatastoreActivity)((DatastoreActivity.Builder)DatastoreActivity.builder().applyMutation(datastore)).build());
        }

        public Builder addAttributes(AddAttributesActivity var1);

        default public Builder addAttributes(Consumer<AddAttributesActivity.Builder> addAttributes) {
            return this.addAttributes((AddAttributesActivity)((AddAttributesActivity.Builder)AddAttributesActivity.builder().applyMutation(addAttributes)).build());
        }

        public Builder removeAttributes(RemoveAttributesActivity var1);

        default public Builder removeAttributes(Consumer<RemoveAttributesActivity.Builder> removeAttributes) {
            return this.removeAttributes((RemoveAttributesActivity)((RemoveAttributesActivity.Builder)RemoveAttributesActivity.builder().applyMutation(removeAttributes)).build());
        }

        public Builder selectAttributes(SelectAttributesActivity var1);

        default public Builder selectAttributes(Consumer<SelectAttributesActivity.Builder> selectAttributes) {
            return this.selectAttributes((SelectAttributesActivity)((SelectAttributesActivity.Builder)SelectAttributesActivity.builder().applyMutation(selectAttributes)).build());
        }

        public Builder filter(FilterActivity var1);

        default public Builder filter(Consumer<FilterActivity.Builder> filter) {
            return this.filter((FilterActivity)((FilterActivity.Builder)FilterActivity.builder().applyMutation(filter)).build());
        }

        public Builder math(MathActivity var1);

        default public Builder math(Consumer<MathActivity.Builder> math) {
            return this.math((MathActivity)((MathActivity.Builder)MathActivity.builder().applyMutation(math)).build());
        }

        public Builder deviceRegistryEnrich(DeviceRegistryEnrichActivity var1);

        default public Builder deviceRegistryEnrich(Consumer<DeviceRegistryEnrichActivity.Builder> deviceRegistryEnrich) {
            return this.deviceRegistryEnrich((DeviceRegistryEnrichActivity)((DeviceRegistryEnrichActivity.Builder)DeviceRegistryEnrichActivity.builder().applyMutation(deviceRegistryEnrich)).build());
        }

        public Builder deviceShadowEnrich(DeviceShadowEnrichActivity var1);

        default public Builder deviceShadowEnrich(Consumer<DeviceShadowEnrichActivity.Builder> deviceShadowEnrich) {
            return this.deviceShadowEnrich((DeviceShadowEnrichActivity)((DeviceShadowEnrichActivity.Builder)DeviceShadowEnrichActivity.builder().applyMutation(deviceShadowEnrich)).build());
        }
    }
}

