/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.ComputeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceConfiguration> {
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeType").getter(ResourceConfiguration.getter(ResourceConfiguration::computeTypeAsString)).setter(ResourceConfiguration.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeSizeInGB").getter(ResourceConfiguration.getter(ResourceConfiguration::volumeSizeInGB)).setter(ResourceConfiguration.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeInGB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_TYPE_FIELD, VOLUME_SIZE_IN_GB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String computeType;
    private final Integer volumeSizeInGB;

    private ResourceConfiguration(BuilderImpl builder) {
        this.computeType = builder.computeType;
        this.volumeSizeInGB = builder.volumeSizeInGB;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfiguration)) {
            return false;
        }
        ResourceConfiguration other = (ResourceConfiguration)obj;
        return Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceConfiguration").add("ComputeType", (Object)this.computeTypeAsString()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "volumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfiguration, T> g) {
        return obj -> g.apply((ResourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computeType;
        private Integer volumeSizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfiguration model) {
            this.computeType(model.computeType);
            this.volumeSizeInGB(model.volumeSizeInGB);
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        @Transient
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        @Transient
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        @Transient
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public ResourceConfiguration build() {
            return new ResourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceConfiguration> {
        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder volumeSizeInGB(Integer var1);
    }
}

