/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivitiesCopier;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineName)).setter(UpdatePipelineRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("pipelineName").build()}).build();
    private static final SdkField<List<PipelineActivity>> PIPELINE_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineActivities").getter(UpdatePipelineRequest.getter(UpdatePipelineRequest::pipelineActivities)).setter(UpdatePipelineRequest.setter(Builder::pipelineActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_ACTIVITIES_FIELD));
    private final String pipelineName;
    private final List<PipelineActivity> pipelineActivities;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineActivities = builder.pipelineActivities;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final boolean hasPipelineActivities() {
        return this.pipelineActivities != null && !(this.pipelineActivities instanceof SdkAutoConstructList);
    }

    public final List<PipelineActivity> pipelineActivities() {
        return this.pipelineActivities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineActivities() ? this.pipelineActivities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && this.hasPipelineActivities() == other.hasPipelineActivities() && Objects.equals(this.pipelineActivities(), other.pipelineActivities());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipelineRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineActivities", this.hasPipelineActivities() ? this.pipelineActivities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineActivities": {
                return Optional.ofNullable(clazz.cast(this.pipelineActivities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private List<PipelineActivity> pipelineActivities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineActivities(model.pipelineActivities);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final List<PipelineActivity.Builder> getPipelineActivities() {
            List<PipelineActivity.Builder> result = PipelineActivitiesCopier.copyToBuilder(this.pipelineActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineActivities(Collection<PipelineActivity.BuilderImpl> pipelineActivities) {
            this.pipelineActivities = PipelineActivitiesCopier.copyFromBuilder(pipelineActivities);
        }

        @Override
        @Transient
        public final Builder pipelineActivities(Collection<PipelineActivity> pipelineActivities) {
            this.pipelineActivities = PipelineActivitiesCopier.copy(pipelineActivities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineActivities(PipelineActivity ... pipelineActivities) {
            this.pipelineActivities(Arrays.asList(pipelineActivities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineActivities(Consumer<PipelineActivity.Builder> ... pipelineActivities) {
            this.pipelineActivities(Stream.of(pipelineActivities).map(c -> (PipelineActivity)((PipelineActivity.Builder)PipelineActivity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineActivities(Collection<PipelineActivity> var1);

        public Builder pipelineActivities(PipelineActivity ... var1);

        public Builder pipelineActivities(Consumer<PipelineActivity.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

