/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.NotificationAction;
import software.amazon.awssdk.services.iotevents.model.NotificationActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmNotification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmNotification> {
    private static final SdkField<List<NotificationAction>> NOTIFICATION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationActions").getter(AlarmNotification.getter(AlarmNotification::notificationActions)).setter(AlarmNotification.setter(Builder::notificationActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<NotificationAction> notificationActions;

    private AlarmNotification(BuilderImpl builder) {
        this.notificationActions = builder.notificationActions;
    }

    public final boolean hasNotificationActions() {
        return this.notificationActions != null && !(this.notificationActions instanceof SdkAutoConstructList);
    }

    public final List<NotificationAction> notificationActions() {
        return this.notificationActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationActions() ? this.notificationActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmNotification)) {
            return false;
        }
        AlarmNotification other = (AlarmNotification)obj;
        return this.hasNotificationActions() == other.hasNotificationActions() && Objects.equals(this.notificationActions(), other.notificationActions());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmNotification").add("NotificationActions", this.hasNotificationActions() ? this.notificationActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationActions": {
                return Optional.ofNullable(clazz.cast(this.notificationActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmNotification, T> g) {
        return obj -> g.apply((AlarmNotification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NotificationAction> notificationActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmNotification model) {
            this.notificationActions(model.notificationActions);
        }

        public final List<NotificationAction.Builder> getNotificationActions() {
            List<NotificationAction.Builder> result = NotificationActionsCopier.copyToBuilder(this.notificationActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationActions(Collection<NotificationAction.BuilderImpl> notificationActions) {
            this.notificationActions = NotificationActionsCopier.copyFromBuilder(notificationActions);
        }

        @Override
        @Transient
        public final Builder notificationActions(Collection<NotificationAction> notificationActions) {
            this.notificationActions = NotificationActionsCopier.copy(notificationActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationActions(NotificationAction ... notificationActions) {
            this.notificationActions(Arrays.asList(notificationActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notificationActions(Consumer<NotificationAction.Builder> ... notificationActions) {
            this.notificationActions(Stream.of(notificationActions).map(c -> (NotificationAction)((NotificationAction.Builder)NotificationAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AlarmNotification build() {
            return new AlarmNotification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmNotification> {
        public Builder notificationActions(Collection<NotificationAction> var1);

        public Builder notificationActions(NotificationAction ... var1);

        public Builder notificationActions(Consumer<NotificationAction.Builder> ... var1);
    }
}

