/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.Action;
import software.amazon.awssdk.services.iotevents.model.ActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventName").getter(Event.getter(Event::eventName)).setter(Event.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventName").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("condition").getter(Event.getter(Event::condition)).setter(Event.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(Event.getter(Event::actions)).setter(Event.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_NAME_FIELD, CONDITION_FIELD, ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventName;
    private final String condition;
    private final List<Action> actions;

    private Event(BuilderImpl builder) {
        this.eventName = builder.eventName;
        this.condition = builder.condition;
        this.actions = builder.actions;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final String condition() {
        return this.condition;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<Action> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventName(), other.eventName()) && Objects.equals(this.condition(), other.condition()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("EventName", (Object)this.eventName()).add("Condition", (Object)this.condition()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventName;
        private String condition;
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventName(model.eventName);
            this.condition(model.condition);
            this.actions(model.actions);
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        @Transient
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        @Transient
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder eventName(String var1);

        public Builder condition(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);
    }
}

