/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideomedia;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.kinesisvideomedia.DefaultKinesisVideoMediaClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideomedia.model.ConnectionLimitExceededException;
import software.amazon.awssdk.services.kinesisvideomedia.model.GetMediaRequest;
import software.amazon.awssdk.services.kinesisvideomedia.model.GetMediaResponse;
import software.amazon.awssdk.services.kinesisvideomedia.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideomedia.model.InvalidEndpointException;
import software.amazon.awssdk.services.kinesisvideomedia.model.KinesisVideoMediaException;
import software.amazon.awssdk.services.kinesisvideomedia.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideomedia.model.ResourceNotFoundException;

@SdkPublicApi
@ThreadSafe
public interface KinesisVideoMediaClient
extends SdkClient {
    public static final String SERVICE_NAME = "kinesisvideo";
    public static final String SERVICE_METADATA_ID = "kinesisvideo";

    public static KinesisVideoMediaClient create() {
        return (KinesisVideoMediaClient)KinesisVideoMediaClient.builder().build();
    }

    public static KinesisVideoMediaClientBuilder builder() {
        return new DefaultKinesisVideoMediaClientBuilder();
    }

    default public <ReturnT> ReturnT getMedia(GetMediaRequest getMediaRequest, ResponseTransformer<GetMediaResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getMedia(Consumer<GetMediaRequest.Builder> getMediaRequest, ResponseTransformer<GetMediaResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return this.getMedia((GetMediaRequest)((Object)((GetMediaRequest.Builder)GetMediaRequest.builder().applyMutation(getMediaRequest)).build()), responseTransformer);
    }

    default public GetMediaResponse getMedia(GetMediaRequest getMediaRequest, Path destinationPath) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return (GetMediaResponse)((Object)this.getMedia(getMediaRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetMediaResponse getMedia(Consumer<GetMediaRequest.Builder> getMediaRequest, Path destinationPath) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return this.getMedia((GetMediaRequest)((Object)((GetMediaRequest.Builder)GetMediaRequest.builder().applyMutation(getMediaRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetMediaResponse> getMedia(GetMediaRequest getMediaRequest) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return (ResponseInputStream)this.getMedia(getMediaRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetMediaResponse> getMedia(Consumer<GetMediaRequest.Builder> getMediaRequest) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return this.getMedia((GetMediaRequest)((Object)((GetMediaRequest.Builder)GetMediaRequest.builder().applyMutation(getMediaRequest)).build()));
    }

    default public ResponseBytes<GetMediaResponse> getMediaAsBytes(GetMediaRequest getMediaRequest) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return (ResponseBytes)this.getMedia(getMediaRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetMediaResponse> getMediaAsBytes(Consumer<GetMediaRequest.Builder> getMediaRequest) throws ResourceNotFoundException, NotAuthorizedException, InvalidEndpointException, ClientLimitExceededException, ConnectionLimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisVideoMediaException {
        return this.getMediaAsBytes((GetMediaRequest)((Object)((GetMediaRequest.Builder)GetMediaRequest.builder().applyMutation(getMediaRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"kinesisvideo");
    }
}

