/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRouteCalculatorsResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListRouteCalculatorsResponseEntry> {
    private static final SdkField<String> CALCULATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatorName").getter(ListRouteCalculatorsResponseEntry.getter(ListRouteCalculatorsResponseEntry::calculatorName)).setter(ListRouteCalculatorsResponseEntry.setter(Builder::calculatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatorName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ListRouteCalculatorsResponseEntry.getter(ListRouteCalculatorsResponseEntry::createTime)).setter(ListRouteCalculatorsResponseEntry.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(ListRouteCalculatorsResponseEntry.getter(ListRouteCalculatorsResponseEntry::dataSource)).setter(ListRouteCalculatorsResponseEntry.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListRouteCalculatorsResponseEntry.getter(ListRouteCalculatorsResponseEntry::description)).setter(ListRouteCalculatorsResponseEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(ListRouteCalculatorsResponseEntry.getter(ListRouteCalculatorsResponseEntry::pricingPlanAsString)).setter(ListRouteCalculatorsResponseEntry.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ListRouteCalculatorsResponseEntry.getter(ListRouteCalculatorsResponseEntry::updateTime)).setter(ListRouteCalculatorsResponseEntry.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALCULATOR_NAME_FIELD, CREATE_TIME_FIELD, DATA_SOURCE_FIELD, DESCRIPTION_FIELD, PRICING_PLAN_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String calculatorName;
    private final Instant createTime;
    private final String dataSource;
    private final String description;
    private final String pricingPlan;
    private final Instant updateTime;

    private ListRouteCalculatorsResponseEntry(BuilderImpl builder) {
        this.calculatorName = builder.calculatorName;
        this.createTime = builder.createTime;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.pricingPlan = builder.pricingPlan;
        this.updateTime = builder.updateTime;
    }

    public final String calculatorName() {
        return this.calculatorName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final String description() {
        return this.description;
    }

    @Deprecated
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    @Deprecated
    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRouteCalculatorsResponseEntry)) {
            return false;
        }
        ListRouteCalculatorsResponseEntry other = (ListRouteCalculatorsResponseEntry)obj;
        return Objects.equals(this.calculatorName(), other.calculatorName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListRouteCalculatorsResponseEntry").add("CalculatorName", (Object)this.calculatorName()).add("CreateTime", (Object)this.createTime()).add("DataSource", (Object)this.dataSource()).add("Description", (Object)this.description()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CalculatorName": {
                return Optional.ofNullable(clazz.cast(this.calculatorName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRouteCalculatorsResponseEntry, T> g) {
        return obj -> g.apply((ListRouteCalculatorsResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String calculatorName;
        private Instant createTime;
        private String dataSource;
        private String description;
        private String pricingPlan;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRouteCalculatorsResponseEntry model) {
            this.calculatorName(model.calculatorName);
            this.createTime(model.createTime);
            this.dataSource(model.dataSource);
            this.description(model.description);
            this.pricingPlan(model.pricingPlan);
            this.updateTime(model.updateTime);
        }

        public final String getCalculatorName() {
            return this.calculatorName;
        }

        public final void setCalculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
        }

        @Override
        @Transient
        public final Builder calculatorName(String calculatorName) {
            this.calculatorName = calculatorName;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        @Transient
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Deprecated
        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        @Transient
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ListRouteCalculatorsResponseEntry build() {
            return new ListRouteCalculatorsResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListRouteCalculatorsResponseEntry> {
        public Builder calculatorName(String var1);

        public Builder createTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder description(String var1);

        @Deprecated
        public Builder pricingPlan(String var1);

        @Deprecated
        public Builder pricingPlan(PricingPlan var1);

        public Builder updateTime(Instant var1);
    }
}

