/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FecOutputIncludeFec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FecOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FecOutputSettings> {
    private static final SdkField<Integer> COLUMN_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ColumnDepth").getter(FecOutputSettings.getter(FecOutputSettings::columnDepth)).setter(FecOutputSettings.setter(Builder::columnDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnDepth").build()}).build();
    private static final SdkField<String> INCLUDE_FEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncludeFec").getter(FecOutputSettings.getter(FecOutputSettings::includeFecAsString)).setter(FecOutputSettings.setter(Builder::includeFec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeFec").build()}).build();
    private static final SdkField<Integer> ROW_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowLength").getter(FecOutputSettings.getter(FecOutputSettings::rowLength)).setter(FecOutputSettings.setter(Builder::rowLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_DEPTH_FIELD, INCLUDE_FEC_FIELD, ROW_LENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer columnDepth;
    private final String includeFec;
    private final Integer rowLength;

    private FecOutputSettings(BuilderImpl builder) {
        this.columnDepth = builder.columnDepth;
        this.includeFec = builder.includeFec;
        this.rowLength = builder.rowLength;
    }

    public final Integer columnDepth() {
        return this.columnDepth;
    }

    public final FecOutputIncludeFec includeFec() {
        return FecOutputIncludeFec.fromValue(this.includeFec);
    }

    public final String includeFecAsString() {
        return this.includeFec;
    }

    public final Integer rowLength() {
        return this.rowLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeFecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FecOutputSettings)) {
            return false;
        }
        FecOutputSettings other = (FecOutputSettings)obj;
        return Objects.equals(this.columnDepth(), other.columnDepth()) && Objects.equals(this.includeFecAsString(), other.includeFecAsString()) && Objects.equals(this.rowLength(), other.rowLength());
    }

    public final String toString() {
        return ToString.builder((String)"FecOutputSettings").add("ColumnDepth", (Object)this.columnDepth()).add("IncludeFec", (Object)this.includeFecAsString()).add("RowLength", (Object)this.rowLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnDepth": {
                return Optional.ofNullable(clazz.cast(this.columnDepth()));
            }
            case "IncludeFec": {
                return Optional.ofNullable(clazz.cast(this.includeFecAsString()));
            }
            case "RowLength": {
                return Optional.ofNullable(clazz.cast(this.rowLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FecOutputSettings, T> g) {
        return obj -> g.apply((FecOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer columnDepth;
        private String includeFec;
        private Integer rowLength;

        private BuilderImpl() {
        }

        private BuilderImpl(FecOutputSettings model) {
            this.columnDepth(model.columnDepth);
            this.includeFec(model.includeFec);
            this.rowLength(model.rowLength);
        }

        public final Integer getColumnDepth() {
            return this.columnDepth;
        }

        public final void setColumnDepth(Integer columnDepth) {
            this.columnDepth = columnDepth;
        }

        @Override
        @Transient
        public final Builder columnDepth(Integer columnDepth) {
            this.columnDepth = columnDepth;
            return this;
        }

        public final String getIncludeFec() {
            return this.includeFec;
        }

        public final void setIncludeFec(String includeFec) {
            this.includeFec = includeFec;
        }

        @Override
        @Transient
        public final Builder includeFec(String includeFec) {
            this.includeFec = includeFec;
            return this;
        }

        @Override
        @Transient
        public final Builder includeFec(FecOutputIncludeFec includeFec) {
            this.includeFec(includeFec == null ? null : includeFec.toString());
            return this;
        }

        public final Integer getRowLength() {
            return this.rowLength;
        }

        public final void setRowLength(Integer rowLength) {
            this.rowLength = rowLength;
        }

        @Override
        @Transient
        public final Builder rowLength(Integer rowLength) {
            this.rowLength = rowLength;
            return this;
        }

        public FecOutputSettings build() {
            return new FecOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FecOutputSettings> {
        public Builder columnDepth(Integer var1);

        public Builder includeFec(String var1);

        public Builder includeFec(FecOutputIncludeFec var1);

        public Builder rowLength(Integer var1);
    }
}

