/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.SupportedHardwareType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOutpostRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, UpdateOutpostRequest> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(UpdateOutpostRequest.getter(UpdateOutpostRequest::outpostId)).setter(UpdateOutpostRequest.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateOutpostRequest.getter(UpdateOutpostRequest::name)).setter(UpdateOutpostRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateOutpostRequest.getter(UpdateOutpostRequest::description)).setter(UpdateOutpostRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SUPPORTED_HARDWARE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportedHardwareType").getter(UpdateOutpostRequest.getter(UpdateOutpostRequest::supportedHardwareTypeAsString)).setter(UpdateOutpostRequest.setter(Builder::supportedHardwareType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedHardwareType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SUPPORTED_HARDWARE_TYPE_FIELD));
    private final String outpostId;
    private final String name;
    private final String description;
    private final String supportedHardwareType;

    private UpdateOutpostRequest(BuilderImpl builder) {
        super(builder);
        this.outpostId = builder.outpostId;
        this.name = builder.name;
        this.description = builder.description;
        this.supportedHardwareType = builder.supportedHardwareType;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final SupportedHardwareType supportedHardwareType() {
        return SupportedHardwareType.fromValue(this.supportedHardwareType);
    }

    public final String supportedHardwareTypeAsString() {
        return this.supportedHardwareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedHardwareTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOutpostRequest)) {
            return false;
        }
        UpdateOutpostRequest other = (UpdateOutpostRequest)((Object)obj);
        return Objects.equals(this.outpostId(), other.outpostId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.supportedHardwareTypeAsString(), other.supportedHardwareTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOutpostRequest").add("OutpostId", (Object)this.outpostId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SupportedHardwareType", (Object)this.supportedHardwareTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SupportedHardwareType": {
                return Optional.ofNullable(clazz.cast(this.supportedHardwareTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOutpostRequest, T> g) {
        return obj -> g.apply((UpdateOutpostRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostId;
        private String name;
        private String description;
        private String supportedHardwareType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOutpostRequest model) {
            super(model);
            this.outpostId(model.outpostId);
            this.name(model.name);
            this.description(model.description);
            this.supportedHardwareType(model.supportedHardwareType);
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        @Transient
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSupportedHardwareType() {
            return this.supportedHardwareType;
        }

        public final void setSupportedHardwareType(String supportedHardwareType) {
            this.supportedHardwareType = supportedHardwareType;
        }

        @Override
        @Transient
        public final Builder supportedHardwareType(String supportedHardwareType) {
            this.supportedHardwareType = supportedHardwareType;
            return this;
        }

        @Override
        @Transient
        public final Builder supportedHardwareType(SupportedHardwareType supportedHardwareType) {
            this.supportedHardwareType(supportedHardwareType == null ? null : supportedHardwareType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOutpostRequest build() {
            return new UpdateOutpostRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOutpostRequest> {
        public Builder outpostId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder supportedHardwareType(String var1);

        public Builder supportedHardwareType(SupportedHardwareType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

