/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCampaignDateRangeKpiRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, GetCampaignDateRangeKpiRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::applicationId)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CampaignId").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::campaignId)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("campaign-id").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::endTime)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("end-time").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> KPI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KpiName").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::kpiName)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::kpiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("kpi-name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::nextToken)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PageSize").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::pageSize)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetCampaignDateRangeKpiRequest.getter(GetCampaignDateRangeKpiRequest::startTime)).setter(GetCampaignDateRangeKpiRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("start-time").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CAMPAIGN_ID_FIELD, END_TIME_FIELD, KPI_NAME_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD, START_TIME_FIELD));
    private final String applicationId;
    private final String campaignId;
    private final Instant endTime;
    private final String kpiName;
    private final String nextToken;
    private final String pageSize;
    private final Instant startTime;

    private GetCampaignDateRangeKpiRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.endTime = builder.endTime;
        this.kpiName = builder.kpiName;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.startTime = builder.startTime;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String kpiName() {
        return this.kpiName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String pageSize() {
        return this.pageSize;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignDateRangeKpiRequest)) {
            return false;
        }
        GetCampaignDateRangeKpiRequest other = (GetCampaignDateRangeKpiRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.kpiName(), other.kpiName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetCampaignDateRangeKpiRequest").add("ApplicationId", (Object)this.applicationId()).add("CampaignId", (Object)this.campaignId()).add("EndTime", (Object)this.endTime()).add("KpiName", (Object)this.kpiName()).add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "KpiName": {
                return Optional.ofNullable(clazz.cast(this.kpiName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignDateRangeKpiRequest, T> g) {
        return obj -> g.apply((GetCampaignDateRangeKpiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;
        private Instant endTime;
        private String kpiName;
        private String nextToken;
        private String pageSize;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignDateRangeKpiRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
            this.endTime(model.endTime);
            this.kpiName(model.kpiName);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
            this.startTime(model.startTime);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        @Transient
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getKpiName() {
            return this.kpiName;
        }

        public final void setKpiName(String kpiName) {
            this.kpiName = kpiName;
        }

        @Override
        @Transient
        public final Builder kpiName(String kpiName) {
            this.kpiName = kpiName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCampaignDateRangeKpiRequest build() {
            return new GetCampaignDateRangeKpiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCampaignDateRangeKpiRequest> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder endTime(Instant var1);

        public Builder kpiName(String var1);

        public Builder nextToken(String var1);

        public Builder pageSize(String var1);

        public Builder startTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

