/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListServiceInstanceOutputsIterable
implements SdkIterable<ListServiceInstanceOutputsResponse> {
    private final ProtonClient client;
    private final ListServiceInstanceOutputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceInstanceOutputsIterable(ProtonClient client, ListServiceInstanceOutputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServiceInstanceOutputsResponseFetcher();
    }

    public Iterator<ListServiceInstanceOutputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Output> outputs() {
        Function<ListServiceInstanceOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceInstanceOutputsResponseFetcher
    implements SyncPageFetcher<ListServiceInstanceOutputsResponse> {
        private ListServiceInstanceOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceInstanceOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceInstanceOutputsResponse nextPage(ListServiceInstanceOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceInstanceOutputsIterable.this.client.listServiceInstanceOutputs(ListServiceInstanceOutputsIterable.this.firstRequest);
            }
            return ListServiceInstanceOutputsIterable.this.client.listServiceInstanceOutputs((ListServiceInstanceOutputsRequest)((Object)ListServiceInstanceOutputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

