/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListServiceInstanceProvisionedResourcesIterable
implements SdkIterable<ListServiceInstanceProvisionedResourcesResponse> {
    private final ProtonClient client;
    private final ListServiceInstanceProvisionedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceInstanceProvisionedResourcesIterable(ProtonClient client, ListServiceInstanceProvisionedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServiceInstanceProvisionedResourcesResponseFetcher();
    }

    public Iterator<ListServiceInstanceProvisionedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProvisionedResource> provisionedResources() {
        Function<ListServiceInstanceProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceInstanceProvisionedResourcesResponseFetcher
    implements SyncPageFetcher<ListServiceInstanceProvisionedResourcesResponse> {
        private ListServiceInstanceProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceInstanceProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceInstanceProvisionedResourcesResponse nextPage(ListServiceInstanceProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceInstanceProvisionedResourcesIterable.this.client.listServiceInstanceProvisionedResources(ListServiceInstanceProvisionedResourcesIterable.this.firstRequest);
            }
            return ListServiceInstanceProvisionedResourcesIterable.this.client.listServiceInstanceProvisionedResources((ListServiceInstanceProvisionedResourcesRequest)((Object)ListServiceInstanceProvisionedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

