/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AliasTarget> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(AliasTarget.getter(AliasTarget::hostedZoneId)).setter(AliasTarget.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(AliasTarget.getter(AliasTarget::dnsName)).setter(AliasTarget.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").unmarshallLocationName("DNSName").build()}).build();
    private static final SdkField<Boolean> EVALUATE_TARGET_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EvaluateTargetHealth").getter(AliasTarget.getter(AliasTarget::evaluateTargetHealth)).setter(AliasTarget.setter(Builder::evaluateTargetHealth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluateTargetHealth").unmarshallLocationName("EvaluateTargetHealth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, DNS_NAME_FIELD, EVALUATE_TARGET_HEALTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostedZoneId;
    private final String dnsName;
    private final Boolean evaluateTargetHealth;

    private AliasTarget(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.dnsName = builder.dnsName;
        this.evaluateTargetHealth = builder.evaluateTargetHealth;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final Boolean evaluateTargetHealth() {
        return this.evaluateTargetHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateTargetHealth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasTarget)) {
            return false;
        }
        AliasTarget other = (AliasTarget)obj;
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.evaluateTargetHealth(), other.evaluateTargetHealth());
    }

    public final String toString() {
        return ToString.builder((String)"AliasTarget").add("HostedZoneId", (Object)this.hostedZoneId()).add("DNSName", (Object)this.dnsName()).add("EvaluateTargetHealth", (Object)this.evaluateTargetHealth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "EvaluateTargetHealth": {
                return Optional.ofNullable(clazz.cast(this.evaluateTargetHealth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasTarget, T> g) {
        return obj -> g.apply((AliasTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String dnsName;
        private Boolean evaluateTargetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasTarget model) {
            this.hostedZoneId(model.hostedZoneId);
            this.dnsName(model.dnsName);
            this.evaluateTargetHealth(model.evaluateTargetHealth);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        @Transient
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        @Transient
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Boolean getEvaluateTargetHealth() {
            return this.evaluateTargetHealth;
        }

        public final void setEvaluateTargetHealth(Boolean evaluateTargetHealth) {
            this.evaluateTargetHealth = evaluateTargetHealth;
        }

        @Override
        @Transient
        public final Builder evaluateTargetHealth(Boolean evaluateTargetHealth) {
            this.evaluateTargetHealth = evaluateTargetHealth;
            return this;
        }

        public AliasTarget build() {
            return new AliasTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AliasTarget> {
        public Builder hostedZoneId(String var1);

        public Builder dnsName(String var1);

        public Builder evaluateTargetHealth(Boolean var1);
    }
}

