/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.DomainPrice;
import software.amazon.awssdk.services.route53domains.model.DomainPriceListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPricesResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, ListPricesResponse> {
    private static final SdkField<List<DomainPrice>> PRICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Prices").getter(ListPricesResponse.getter(ListPricesResponse::prices)).setter(ListPricesResponse.setter(Builder::prices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainPrice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageMarker").getter(ListPricesResponse.getter(ListPricesResponse::nextPageMarker)).setter(ListPricesResponse.setter(Builder::nextPageMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICES_FIELD, NEXT_PAGE_MARKER_FIELD));
    private final List<DomainPrice> prices;
    private final String nextPageMarker;

    private ListPricesResponse(BuilderImpl builder) {
        super(builder);
        this.prices = builder.prices;
        this.nextPageMarker = builder.nextPageMarker;
    }

    public final boolean hasPrices() {
        return this.prices != null && !(this.prices instanceof SdkAutoConstructList);
    }

    public final List<DomainPrice> prices() {
        return this.prices;
    }

    public final String nextPageMarker() {
        return this.nextPageMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrices() ? this.prices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricesResponse)) {
            return false;
        }
        ListPricesResponse other = (ListPricesResponse)((Object)obj);
        return this.hasPrices() == other.hasPrices() && Objects.equals(this.prices(), other.prices()) && Objects.equals(this.nextPageMarker(), other.nextPageMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListPricesResponse").add("Prices", this.hasPrices() ? this.prices() : null).add("NextPageMarker", (Object)this.nextPageMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Prices": {
                return Optional.ofNullable(clazz.cast(this.prices()));
            }
            case "NextPageMarker": {
                return Optional.ofNullable(clazz.cast(this.nextPageMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPricesResponse, T> g) {
        return obj -> g.apply((ListPricesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private List<DomainPrice> prices = DefaultSdkAutoConstructList.getInstance();
        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricesResponse model) {
            super(model);
            this.prices(model.prices);
            this.nextPageMarker(model.nextPageMarker);
        }

        public final List<DomainPrice.Builder> getPrices() {
            List<DomainPrice.Builder> result = DomainPriceListCopier.copyToBuilder(this.prices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrices(Collection<DomainPrice.BuilderImpl> prices) {
            this.prices = DomainPriceListCopier.copyFromBuilder(prices);
        }

        @Override
        @Transient
        public final Builder prices(Collection<DomainPrice> prices) {
            this.prices = DomainPriceListCopier.copy(prices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder prices(DomainPrice ... prices) {
            this.prices(Arrays.asList(prices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder prices(Consumer<DomainPrice.Builder> ... prices) {
            this.prices(Stream.of(prices).map(c -> (DomainPrice)((DomainPrice.Builder)DomainPrice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        @Transient
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        @Override
        public ListPricesResponse build() {
            return new ListPricesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPricesResponse> {
        public Builder prices(Collection<DomainPrice> var1);

        public Builder prices(DomainPrice ... var1);

        public Builder prices(Consumer<DomainPrice.Builder> ... var1);

        public Builder nextPageMarker(String var1);
    }
}

